/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SpellScrollItem
extends Item {
    protected static final Component TOOLTIP = Component.translatable((String)"tooltip.primalmagick.spell_scroll").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});

    public SpellScrollItem() {
        super(new Item.Properties());
    }

    @Nullable
    public SpellPackage getSpell(@Nonnull ItemStack stack) {
        return (SpellPackage)stack.get(DataComponentsPM.SPELL_PACKAGE.get());
    }

    public void setSpell(@Nonnull ItemStack stack, @Nonnull SpellPackage spell) {
        stack.set(DataComponentsPM.SPELL_PACKAGE.get(), (Object)spell);
        stack.set(DataComponents.RARITY, (Object)(spell == null ? Rarity.COMMON : spell.getRarity()));
    }

    public Component getName(ItemStack stack) {
        SpellPackage spell = this.getSpell(stack);
        MutableComponent spellName = spell == null ? Component.translatable((String)"tooltip.primalmagick.none") : spell.getDisplayName();
        return Component.translatable((String)this.getDescriptionId(stack), (Object[])new Object[]{spellName}).withStyle(ChatFormatting.ITALIC);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.addAll(SpellManager.getSpellPackageDetailTooltip(this.getSpell(stack), stack, null, false, context.registries()));
        tooltip.add(TOOLTIP);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        if (!worldIn.isClientSide) {
            SpellPackage spell = this.getSpell(stack);
            if (spell != null && !SpellManager.isOnCooldown(playerIn)) {
                SpellManager.setCooldown(playerIn, spell.getCooldownTicks());
                spell.cast(worldIn, (LivingEntity)playerIn, stack);
                if (!playerIn.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
        SpellPackage spell = this.getSpell(stack);
        if (spell != null) {
            StatsManager.incrementValue(playerIn, StatsPM.SPELLS_CRAFTED, stack.getCount());
            StatsManager.setValueIfMax(playerIn, StatsPM.SPELLS_CRAFTED_MAX_COST, spell.getManaCost().getManaSize() / 100);
        }
    }
}

