/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.verdantartifice.primalmagick.client.renderers.itemstack.ModularWandISTER;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.wands.AbstractWandItem;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import com.verdantartifice.primalmagick.common.wands.ManaManager;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ModularWandItem
extends AbstractWandItem
implements IHasWandComponents {
    protected static final int BASE_CORE_REGEN_PER_TICK = 5;
    private BlockEntityWithoutLevelRenderer customRenderer;

    public ModularWandItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getMaxMana(ItemStack stack, @Nullable Source source) {
        if (stack == null) {
            return 2500;
        }
        WandGem gem = this.getWandGem(stack);
        if (gem == null) {
            return 2500;
        }
        if (gem.getCapacity() == -1) {
            return -1;
        }
        return gem.getCapacity();
    }

    @Override
    public int getBaseCostModifier(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        WandCap cap = this.getWandCap(stack);
        return cap == null ? 0 : cap.getBaseCostModifier();
    }

    @Override
    public int getSiphonAmount(ItemStack stack) {
        if (stack == null) {
            return WandCap.IRON.getSiphonAmount();
        }
        WandCap cap = this.getWandCap(stack);
        return cap == null ? WandCap.IRON.getSiphonAmount() : cap.getSiphonAmount();
    }

    @Override
    public int getTotalCostModifier(ItemStack stack, Player player, Source source, HolderLookup.Provider registries) {
        int mod = super.getTotalCostModifier(stack, player, source, registries);
        WandCore core = this.getWandCore(stack);
        if (core != null && core.getAlignedSources().contains(source)) {
            mod += 5;
        }
        return mod;
    }

    @Override
    public boolean isGlamoured(ItemStack stack) {
        return stack.has(DataComponentsPM.WAND_CORE_APPEARANCE.get()) || stack.has(DataComponentsPM.WAND_CAP_APPEARANCE.get()) || stack.has(DataComponentsPM.WAND_GEM_APPEARANCE.get());
    }

    @Override
    @Nullable
    public WandCore getWandCore(@Nonnull ItemStack stack) {
        return (WandCore)stack.get(DataComponentsPM.WAND_CORE.get());
    }

    @Override
    public void setWandCore(@Nonnull ItemStack stack, @Nonnull WandCore core) {
        stack.set(DataComponentsPM.WAND_CORE.get(), (Object)core);
        stack.set(DataComponents.RARITY, (Object)this.calculateRarity(stack));
    }

    @Override
    @Nullable
    public WandCore getWandCoreAppearance(@Nonnull ItemStack stack) {
        return (WandCore)stack.getOrDefault(DataComponentsPM.WAND_CORE_APPEARANCE.get(), (Object)this.getWandCore(stack));
    }

    @Override
    public void setWandCoreAppearance(@Nonnull ItemStack stack, @Nullable WandCore core) {
        if (core == null) {
            stack.remove(DataComponentsPM.WAND_CORE_APPEARANCE.get());
        } else {
            stack.set(DataComponentsPM.WAND_CORE_APPEARANCE.get(), (Object)core);
        }
    }

    @Override
    @Nullable
    public WandCap getWandCap(@Nonnull ItemStack stack) {
        return (WandCap)stack.get(DataComponentsPM.WAND_CAP.get());
    }

    @Override
    public void setWandCap(@Nonnull ItemStack stack, @Nonnull WandCap cap) {
        stack.set(DataComponentsPM.WAND_CAP.get(), (Object)cap);
        stack.set(DataComponents.RARITY, (Object)this.calculateRarity(stack));
    }

    @Override
    @Nullable
    public WandCap getWandCapAppearance(@Nonnull ItemStack stack) {
        return (WandCap)stack.getOrDefault(DataComponentsPM.WAND_CAP_APPEARANCE.get(), (Object)this.getWandCap(stack));
    }

    @Override
    public void setWandCapAppearance(@Nonnull ItemStack stack, @Nullable WandCap cap) {
        if (cap == null) {
            stack.remove(DataComponentsPM.WAND_CAP_APPEARANCE.get());
        } else {
            stack.set(DataComponentsPM.WAND_CAP_APPEARANCE.get(), (Object)cap);
        }
    }

    @Override
    @Nullable
    public WandGem getWandGem(@Nonnull ItemStack stack) {
        return (WandGem)stack.get(DataComponentsPM.WAND_GEM.get());
    }

    @Override
    public void setWandGem(@Nonnull ItemStack stack, @Nonnull WandGem gem) {
        stack.set(DataComponentsPM.WAND_GEM.get(), (Object)gem);
        stack.set(DataComponents.RARITY, (Object)this.calculateRarity(stack));
    }

    @Override
    @Nullable
    public WandGem getWandGemAppearance(@Nonnull ItemStack stack) {
        return (WandGem)stack.getOrDefault(DataComponentsPM.WAND_GEM_APPEARANCE.get(), (Object)this.getWandGem(stack));
    }

    @Override
    public void setWandGemAppearance(@Nonnull ItemStack stack, @Nullable WandGem gem) {
        if (gem == null) {
            stack.remove(DataComponentsPM.WAND_GEM_APPEARANCE.get());
        } else {
            stack.set(DataComponentsPM.WAND_GEM_APPEARANCE.get(), (Object)gem);
        }
    }

    @Nonnull
    protected List<IWandComponent> getComponents(@Nonnull ItemStack stack) {
        return Arrays.asList(this.getWandCore(stack), this.getWandCap(stack), this.getWandGem(stack)).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Component getName(ItemStack stack) {
        WandCore core = this.getWandCore(stack);
        MutableComponent coreName = core == null ? Component.translatable((String)"wand_core.primalmagick.unknown") : Component.translatable((String)core.getNameTranslationKey());
        WandCap cap = this.getWandCap(stack);
        MutableComponent capName = cap == null ? Component.translatable((String)"wand_cap.primalmagick.unknown") : Component.translatable((String)cap.getNameTranslationKey());
        WandGem gem = this.getWandGem(stack);
        MutableComponent gemName = gem == null ? Component.translatable((String)"wand_gem.primalmagick.unknown") : Component.translatable((String)gem.getNameTranslationKey());
        return Component.translatable((String)"item.primalmagick.modular_wand", (Object[])new Object[]{gemName, capName, coreName});
    }

    protected Rarity calculateRarity(ItemStack stack) {
        WandGem gem;
        WandCap cap;
        Rarity retVal = Rarity.COMMON;
        WandCore core = this.getWandCore(stack);
        if (core != null && core.getRarity().compareTo((Enum)retVal) > 0) {
            retVal = core.getRarity();
        }
        if ((cap = this.getWandCap(stack)) != null && cap.getRarity().compareTo((Enum)retVal) > 0) {
            retVal = cap.getRarity();
        }
        if ((gem = this.getWandGem(stack)) != null && gem.getRarity().compareTo((Enum)retVal) > 0) {
            retVal = gem.getRarity();
        }
        return retVal;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public static void registerCreativeTabItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output, Supplier<? extends ItemLike> itemSupplier) {
        Item item = itemSupplier.get().asItem();
        if (item instanceof ModularWandItem) {
            ModularWandItem wandItem = (ModularWandItem)item;
            ItemStack stack = new ItemStack((ItemLike)wandItem);
            wandItem.setWandCore(stack, WandCore.HEARTWOOD);
            wandItem.setWandCap(stack, WandCap.IRON);
            wandItem.setWandGem(stack, WandGem.APPRENTICE);
            stack.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.emptyWand(WandGem.APPRENTICE.getCapacity()));
            output.accept(stack);
            stack = new ItemStack((ItemLike)wandItem);
            wandItem.setWandCore(stack, WandCore.HEARTWOOD);
            wandItem.setWandCap(stack, WandCap.IRON);
            wandItem.setWandGem(stack, WandGem.CREATIVE);
            stack.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.emptyWand(-1));
            output.accept(stack);
        }
    }

    protected int getCoreRegenPerTick(ItemStack wandStack, LivingEntity wielderEntity) {
        return 5 + EnchantmentHelperPM.getEquippedEnchantmentLevel(wielderEntity, EnchantmentsPM.PONDERING);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        WandCore core = this.getWandCore(stack);
        if (core != null && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            int regenAmount = this.getCoreRegenPerTick(stack, (LivingEntity)player);
            for (Source alignedSource : core.getAlignedSources()) {
                int maxMana = ManaManager.getMaxMana(player, alignedSource);
                int curMana = ManaManager.getMana(player, alignedSource);
                double targetMax = 0.1 * (double)maxMana;
                if (maxMana == -1 || !((double)curMana < targetMax)) continue;
                ManaManager.addMana(player, stack, alignedSource, regenAmount, (int)targetMax);
            }
        }
    }

    protected int getCoreSpellSlotCount(@Nullable WandCore core) {
        return core == null ? 0 : core.getSpellSlots();
    }

    @Override
    public Component getSpellCapacityText(ItemStack stack) {
        if (stack == null) {
            return Component.translatable((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{0});
        }
        WandCore core = this.getWandCore(stack);
        if (core == null) {
            return Component.translatable((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{0});
        }
        int baseSlots = this.getCoreSpellSlotCount(core);
        Source bonusSlot = core.getBonusSlot();
        if (bonusSlot == null) {
            return Component.translatable((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{baseSlots});
        }
        MutableComponent bonusText = Component.translatable((String)bonusSlot.getNameTranslationKey());
        return Component.translatable((String)"tooltip.primalmagick.spells.capacity_with_bonus", (Object[])new Object[]{baseSlots, bonusText});
    }

    @Override
    public boolean canAddSpell(ItemStack stack, SpellPackage spell) {
        if (stack == null || spell == null || spell.payload() == null) {
            return false;
        }
        WandCore core = this.getWandCore(stack);
        if (core == null) {
            return false;
        }
        List spellSources = this.getSpells(stack).stream().filter(p -> p != null && p.payload() != null).map(p -> ((AbstractSpellPayload)p.payload().getComponent()).getSource()).collect(Collectors.toCollection(ArrayList::new));
        spellSources.add(((AbstractSpellPayload)spell.payload().getComponent()).getSource());
        int coreSlots = this.getCoreSpellSlotCount(core);
        if (spellSources.size() < coreSlots + 1) {
            return true;
        }
        if (spellSources.size() > coreSlots + 1) {
            return false;
        }
        return core.getBonusSlot() != null && spellSources.contains(core.getBonusSlot());
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplier() {
        if (this.customRenderer == null) {
            this.customRenderer = this.getCustomRendererSupplierUncached().get();
        }
        return () -> this.customRenderer;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplierUncached() {
        return ModularWandISTER::new;
    }
}

