/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.verdantartifice.primalmagick.client.renderers.itemstack.ModularStaffISTER;
import com.verdantartifice.primalmagick.common.items.wands.ModularWandItem;
import com.verdantartifice.primalmagick.common.wands.IStaff;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;

public abstract class ModularStaffItem
extends ModularWandItem
implements IStaff {
    private BlockEntityWithoutLevelRenderer customRenderer;

    public ModularStaffItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes(double damage, double attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public Component getName(ItemStack stack) {
        WandCore core = this.getWandCore(stack);
        MutableComponent coreName = core == null ? Component.translatable((String)"wand_core.primalmagick.unknown") : Component.translatable((String)core.getNameTranslationKey());
        WandCap cap = this.getWandCap(stack);
        MutableComponent capName = cap == null ? Component.translatable((String)"wand_cap.primalmagick.unknown") : Component.translatable((String)cap.getNameTranslationKey());
        WandGem gem = this.getWandGem(stack);
        MutableComponent gemName = gem == null ? Component.translatable((String)"wand_gem.primalmagick.unknown") : Component.translatable((String)gem.getNameTranslationKey());
        return Component.translatable((String)"item.primalmagick.modular_staff", (Object[])new Object[]{gemName, capName, coreName});
    }

    @Override
    protected int getCoreSpellSlotCount(WandCore core) {
        return core == null ? 0 : 2 * core.getSpellSlots();
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplier() {
        if (this.customRenderer == null) {
            this.customRenderer = this.getCustomRendererSupplierUncached().get();
        }
        return () -> this.customRenderer;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplierUncached() {
        return ModularStaffISTER::new;
    }
}

