/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.crafting.IWandTransform;
import com.verdantartifice.primalmagick.common.crafting.WandTransforms;
import com.verdantartifice.primalmagick.common.items.IHasCustomRenderer;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.ManaManager;
import com.verdantartifice.primalmagick.platform.Services;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWandItem
extends Item
implements IWand,
IHasCustomRenderer {
    protected static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    protected static final ResearchEntryKey WAND_TRANSFORM_HINT_KEY = new ResearchEntryKey(ResearchEntries.WAND_TRANSFORM_HINT);

    public AbstractWandItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.2-beta")
    public ManaStorage getManaStorage(ItemStack stack) {
        if (stack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) {
            return (ManaStorage)stack.get(DataComponentsPM.CAPABILITY_MANA_STORAGE.get());
        }
        ManaStorage retVal = ManaStorage.emptyWand(this.getMaxMana(stack, null));
        retVal.setMana((SourceList)stack.getOrDefault(DataComponentsPM.STORED_CENTIMANA.get(), (Object)SourceList.EMPTY));
        stack.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)retVal);
        stack.remove(DataComponentsPM.STORED_CENTIMANA.get());
        return retVal;
    }

    @Deprecated(forRemoval=true, since="6.0.2-beta")
    private void updateManaStorageWith(ItemStack stack, Source source, int amount) {
        if (stack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) {
            stack.update(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY, mana -> mana.copyWith(source, amount));
            stack.set(DataComponentsPM.LAST_UPDATED.get(), (Object)System.currentTimeMillis());
        } else {
            ManaStorage newStorage = ManaStorage.emptyWand(this.getMaxMana(stack, source));
            newStorage.setMana((SourceList)stack.getOrDefault(DataComponentsPM.STORED_CENTIMANA.get(), (Object)SourceList.EMPTY));
            newStorage.setMana(source, amount);
            stack.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)newStorage);
            stack.remove(DataComponentsPM.STORED_CENTIMANA.get());
        }
    }

    @Override
    public void setMana(@NotNull ItemStack stack, @NotNull Source source, int amount) {
        this.updateManaStorageWith(stack, source, amount);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        boolean showDetails;
        super.appendHoverText(stack, context, tooltip, flagIn);
        Player player = Services.PLATFORM.isClientDist() ? ClientUtils.getCurrentPlayer() : null;
        boolean bl = showDetails = Services.PLATFORM.isClientDist() && ClientUtils.hasShiftDown();
        if (showDetails) {
            for (Source source : Sources.getAllSorted()) {
                if (!source.isDiscovered(player)) continue;
                Component nameComp = source.getNameText();
                int modifier = this.getTotalCostModifier(stack, player, source, context.registries());
                MutableComponent line = Component.translatable((String)"tooltip.primalmagick.source.mana", (Object[])new Object[]{nameComp, this.getManaText(stack, source, false), this.getMaxManaText(stack, source), modifier});
                tooltip.add((Component)line);
            }
            SpellManager.appendSpellListingText(player, stack, context, tooltip);
        } else {
            boolean first = true;
            MutableComponent summaryText = Component.literal((String)"");
            for (Source source : Sources.getAllSorted()) {
                if (!source.isDiscovered(player)) continue;
                MutableComponent manaText = this.getManaText(stack, source, true).withStyle(source.getChatColor());
                summaryText = first ? manaText : Component.translatable((String)"tooltip.primalmagick.source.mana_summary_fragment", (Object[])new Object[]{summaryText, manaText});
                first = false;
            }
            tooltip.add((Component)summaryText);
            SpellManager.appendActiveSpellText(stack, tooltip);
            tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.more_info").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @Override
    public BlockPos getPositionInUse(ItemStack wandStack) {
        return (BlockPos)wandStack.get(DataComponentsPM.WAND_USE_POSITION.get());
    }

    @Override
    public void setPositionInUse(ItemStack wandStack, BlockPos pos) {
        wandStack.set(DataComponentsPM.WAND_USE_POSITION.get(), (Object)pos.immutable());
    }

    @Override
    public void clearPositionInUse(ItemStack wandStack) {
        wandStack.remove(DataComponentsPM.WAND_USE_POSITION.get());
    }

    protected static boolean isTargetWandInteractable(Level level, Player player, HitResult hit) {
        if (hit != null && hit.getType() == HitResult.Type.BLOCK && hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.getBlockPos();
            if (level.getBlockState(pos).getBlock() instanceof IInteractWithWand || level.getBlockEntity(pos) instanceof IInteractWithWand) {
                return true;
            }
            return WandTransforms.getAll().stream().anyMatch(t -> t.isValid(level, player, pos));
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        SpellPackage activeSpell = SpellManager.getActiveSpell(playerIn.getMainHandItem(), playerIn.getOffhandItem());
        if (activeSpell != null && !SpellManager.isOnCooldown(playerIn)) {
            SpellManager.setCooldown(playerIn, activeSpell.getCooldownTicks());
            if (worldIn.isClientSide) {
                return InteractionResultHolder.success((Object)stack);
            }
            BlockHitResult hit = AbstractWandItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (AbstractWandItem.isTargetWandInteractable(worldIn, playerIn, (HitResult)hit)) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (ManaManager.consumeMana(playerIn, stack, activeSpell.getManaCost(), (HolderLookup.Provider)worldIn.registryAccess())) {
                activeSpell.cast(worldIn, (LivingEntity)playerIn, stack);
                playerIn.swing(handIn);
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public abstract InteractionResult onItemUseFirst(ItemStack var1, UseOnContext var2);

    public void onUseTick(Level level, LivingEntity living, ItemStack stack, int count) {
        if (living instanceof Player) {
            Object object;
            Player player = (Player)living;
            BlockPos wandPos = this.getPositionInUse(stack);
            if (wandPos != null && (object = level.getBlockEntity(wandPos)) instanceof IInteractWithWand) {
                IInteractWithWand wandable = (IInteractWithWand)object;
                Vec3 playerPos = player.position().add(0.0, (double)player.getEyeHeight() / 2.0, 0.0);
                wandable.onWandUseTick(stack, level, player, playerPos, count);
            } else if (wandPos != null) {
                for (IWandTransform transform : WandTransforms.getAll()) {
                    if (!transform.isValid(level, player, wandPos)) continue;
                    if (level.isClientSide) {
                        FxDispatcher.INSTANCE.spellImpact((double)wandPos.getX() + 0.5, (double)wandPos.getY() + 0.5, (double)wandPos.getZ() + 0.5, 2, Sources.HALLOWED.getColor());
                    }
                    if (this.getUseDuration(stack, living) - count < 40) continue;
                    if (level.isClientSide) break;
                    transform.execute(level, player, wandPos);
                    break;
                }
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        Player player;
        super.releaseUsing(stack, worldIn, entityLiving, timeLeft);
        BlockPos wandPos = this.getPositionInUse(stack);
        if (wandPos != null && !worldIn.isClientSide && entityLiving instanceof Player && !WAND_TRANSFORM_HINT_KEY.isKnownBy(player = (Player)entityLiving)) {
            for (IWandTransform transform : WandTransforms.getAll()) {
                if (!transform.isValid(worldIn, player, wandPos) || this.getUseDuration(stack, entityLiving) - timeLeft >= 40) continue;
                ResearchManager.completeResearch(player, WAND_TRANSFORM_HINT_KEY);
                player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.wand_transform_hint").withStyle(ChatFormatting.GREEN));
                break;
            }
        }
        this.clearPositionInUse(stack);
    }
}

