/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.tools;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class TieredFishingRodItem
extends FishingRodItem {
    protected final Tier tier;

    public TieredFishingRodItem(Tier tier, Item.Properties properties) {
        super(properties.durability(tier.getUses() / 4));
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.fishing != null) {
            if (!level.isClientSide) {
                int val = player.fishing.retrieve(stack);
                stack.hurtAndBreak(val, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int lure = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player) * 20.0f);
                int luck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player);
                level.addFreshEntity((Entity)new FishingHook(player, level, luck, lure));
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getEnchantmentValue() {
        return this.tier.getEnchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return this.tier.getRepairIngredient().test(repair) || super.isValidRepairItem(toRepair, repair);
    }
}

