/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.tools;

import com.verdantartifice.primalmagick.client.renderers.itemstack.SpelltomeISTER;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.items.IHasCustomRenderer;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.wands.ISpellContainer;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpelltomeItem
extends Item
implements Equipable,
IHasCustomRenderer,
ITieredDevice,
ISpellContainer {
    private final DeviceTier tier;
    private BlockEntityWithoutLevelRenderer customRenderer;

    public SpelltomeItem(DeviceTier tier, Item.Properties pProperties) {
        super(pProperties);
        this.tier = tier;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplier() {
        if (this.customRenderer == null) {
            this.customRenderer = this.getCustomRendererSupplierUncached().get();
        }
        return () -> this.customRenderer;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplierUncached() {
        return SpelltomeISTER::new;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.OFFHAND;
    }

    @NotNull
    public Holder<SoundEvent> getEquipSound() {
        return SoundsPM.PAGE.getHolder();
    }

    @Override
    public DeviceTier getDeviceTier() {
        return this.tier;
    }

    protected int getSpellCapacity() {
        return switch (this.getDeviceTier()) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> 1;
            case DeviceTier.ENCHANTED -> 2;
            case DeviceTier.FORBIDDEN -> 3;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> 4;
        };
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 8 + 5 * this.getSpellCapacity();
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        boolean showDetails;
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        Player player = Services.PLATFORM.isClientDist() ? ClientUtils.getCurrentPlayer() : null;
        boolean bl = showDetails = Services.PLATFORM.isClientDist() && ClientUtils.hasShiftDown();
        if (showDetails) {
            SpellManager.appendSpellListingText(player, pStack, pContext, pTooltipComponents);
        } else {
            SpellManager.appendActiveSpellText(pStack, pTooltipComponents);
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.more_info").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    @Override
    public Component getSpellCapacityText(@Nullable ItemStack stack) {
        if (stack == null) {
            return Component.translatable((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{0});
        }
        return Component.translatable((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{this.getSpellCapacity()});
    }

    @Override
    public boolean canAddSpell(@Nullable ItemStack stack, @Nullable SpellPackage spell) {
        if (stack == null || spell == null || spell.payload() == null) {
            return false;
        }
        List spellSources = this.getSpells(stack).stream().filter(p -> p != null && p.payload() != null).map(p -> ((AbstractSpellPayload)p.payload().getComponent()).getSource()).collect(Collectors.toCollection(ArrayList::new));
        spellSources.add(((AbstractSpellPayload)spell.payload().getComponent()).getSource());
        int slots = this.getSpellCapacity();
        return spellSources.size() < slots + 1;
    }
}

