/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.tools;

import com.verdantartifice.primalmagick.client.renderers.itemstack.ManaOrbISTER;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.IHasCustomRenderer;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.wands.IManaContainer;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ManaOrbItem
extends Item
implements Equipable,
IHasCustomRenderer,
ITieredDevice,
IManaContainer {
    private final DeviceTier tier;
    private BlockEntityWithoutLevelRenderer customRenderer;

    public ManaOrbItem(DeviceTier tier, Item.Properties pProperties) {
        super(pProperties);
        this.tier = tier;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplier() {
        if (this.customRenderer == null) {
            this.customRenderer = this.getCustomRendererSupplierUncached().get();
        }
        return () -> this.customRenderer;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplierUncached() {
        return ManaOrbISTER::new;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.OFFHAND;
    }

    @Override
    public DeviceTier getDeviceTier() {
        return this.tier;
    }

    public boolean isEnchantable(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue() {
        return switch (this.getDeviceTier()) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> 13;
            case DeviceTier.ENCHANTED -> 18;
            case DeviceTier.FORBIDDEN -> 23;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> 28;
        };
    }

    @NotNull
    private static Optional<WandGem> getWandGemEquivalent(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ManaOrbItem) {
            ManaOrbItem orbItem = (ManaOrbItem)item;
            WandGem gem = switch (orbItem.getDeviceTier()) {
                default -> throw new MatchException(null, null);
                case DeviceTier.BASIC -> WandGem.APPRENTICE;
                case DeviceTier.ENCHANTED -> WandGem.ADEPT;
                case DeviceTier.FORBIDDEN -> WandGem.WIZARD;
                case DeviceTier.HEAVENLY -> WandGem.ARCHMAGE;
                case DeviceTier.CREATIVE -> WandGem.CREATIVE;
            };
            return Optional.of(gem);
        }
        return Optional.empty();
    }

    @Override
    public ManaStorage getManaStorage(ItemStack stack) {
        return (ManaStorage)stack.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY);
    }

    protected boolean isAttuned(ItemStack stack) {
        return !this.getManaStorage(stack).equals(ManaStorage.EMPTY);
    }

    protected boolean isAttuned(ItemStack stack, Source source) {
        return this.getManaStorage(stack).canStore(source);
    }

    public static ItemStack attuneStorage(@NotNull ItemStack stack, @Nullable Source source) {
        if (stack.getItem() instanceof ManaOrbItem) {
            ItemStack retVal = stack.copy();
            if (source == null) {
                retVal.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY);
            } else if (!((ManaStorage)stack.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).canStore(source)) {
                retVal.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.emptyManaOrb(source, ManaOrbItem.getWandGemEquivalent(stack).map(WandGem::getCapacity).orElse(0)));
            }
            return retVal;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getMaxMana(@Nullable ItemStack stack, @Nullable Source source) {
        if (stack == null || source == null) {
            return 0;
        }
        return this.getManaStorage(stack).getMaxManaStored(source);
    }

    @Override
    public void setMana(@NotNull ItemStack stack, @NotNull Source source, int amount) {
        stack.update(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY, mana -> mana.copyWith(source, amount));
    }

    @Override
    public int getBaseCostModifier(@Nullable ItemStack stack) {
        return 0;
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (this.isAttuned(pStack)) {
            for (Source source : Sources.getAllSorted()) {
                if (!this.isAttuned(pStack, source)) continue;
                Component nameComp = source.getNameText();
                MutableComponent line = Component.translatable((String)"tooltip.primalmagick.source.mana_gauge", (Object[])new Object[]{nameComp, this.getManaText(pStack, source, false), this.getMaxManaText(pStack, source)});
                pTooltipComponents.add((Component)line);
            }
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.mana_orb.unattuned").withStyle(ChatFormatting.GRAY));
        }
    }
}

