/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.tools;

import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public enum ItemTierPM implements Tier
{
    PRIMALITE((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 800, 7.5f, 2.5f, 18, () -> Ingredient.of(ItemTagsPM.INGOTS_PRIMALITE)),
    HEXIUM((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1600, 9.5f, 4.0f, 23, () -> Ingredient.of(ItemTagsPM.INGOTS_HEXIUM)),
    HALLOWSTEEL((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 2400, 11.5f, 5.5f, 28, () -> Ingredient.of(ItemTagsPM.INGOTS_HALLOWSTEEL));

    private final TagKey<Block> incorrectBlocks;
    private final int maxUses;
    private final float efficiency;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<Ingredient> repairMaterial;

    private ItemTierPM(TagKey<Block> incorrectBlocks, int maxUses, float efficiency, float attackDamage, int enchantability, Supplier<Ingredient> repairMaterial) {
        this.incorrectBlocks = incorrectBlocks;
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.repairMaterial = repairMaterial;
    }

    public int getUses() {
        return this.maxUses;
    }

    public float getSpeed() {
        return this.efficiency;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return this.repairMaterial.get();
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocks;
    }
}

