/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.tools;

import com.verdantartifice.primalmagick.common.entities.projectiles.AbstractTridentEntity;
import com.verdantartifice.primalmagick.common.items.IHasCustomRenderer;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractTieredTridentItem
extends TridentItem
implements IHasCustomRenderer {
    protected final Tier tier;

    public AbstractTieredTridentItem(Tier tier, Item.Properties properties) {
        super(properties.durability(tier.getUses()).attributes(AbstractTieredTridentItem.createAttributes(tier)).component(DataComponents.TOOL, (Object)AbstractTieredTridentItem.createToolProperties()));
        this.tier = tier;
    }

    public static ItemAttributeModifiers createAttributes(Tier tier) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 7.0 + (double)tier.getAttackDamageBonus(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.9, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getEnchantmentValue() {
        return this.tier.getEnchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return this.tier.getRepairIngredient().test(repair) || super.isValidRepairItem(toRepair, repair);
    }

    protected abstract AbstractTridentEntity getThrownEntity(Level var1, LivingEntity var2, ItemStack var3);

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            float riptide;
            Player player = (Player)entityLiving;
            int duration = this.getUseDuration(stack, entityLiving) - timeLeft;
            if (duration >= 10 && ((riptide = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)stack, (LivingEntity)player)) <= 0.0f || player.isInWaterOrRain()) && !AbstractTieredTridentItem.isTooDamagedToUse(stack)) {
                Holder soundHolder = EnchantmentHelper.pickHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                if (!worldIn.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)entityLiving.getUsedItemHand()));
                    if (riptide == 0.0f) {
                        AbstractTridentEntity trident = this.getThrownEntity(worldIn, (LivingEntity)player, stack);
                        trident.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f + riptide * 0.5f, 1.0f);
                        if (player.hasInfiniteMaterials()) {
                            trident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.addFreshEntity((Entity)trident);
                        worldIn.playSound((Player)null, (Entity)trident, (SoundEvent)soundHolder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.hasInfiniteMaterials()) {
                            player.getInventory().removeItem(stack);
                        }
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (riptide > 0.0f) {
                    float f7 = player.getYRot();
                    float f = player.getXRot();
                    float f1 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.sin((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.sqrt((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + riptide) / 4.0f);
                    player.push((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.startAutoSpinAttack(20, 7.0f + this.tier.getAttackDamageBonus(), stack);
                    if (player.onGround()) {
                        player.move(MoverType.SELF, new Vec3(0.0, 1.1999999, 0.0));
                    }
                    worldIn.playSound((Player)null, (Entity)player, (SoundEvent)soundHolder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    private static boolean isTooDamagedToUse(ItemStack pStack) {
        return pStack.getDamageValue() >= pStack.getMaxDamage() - 1;
    }
}

