/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TickStickItem
extends Item {
    public TickStickItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = pContext.getClickedPos();
            BlockState state = level.getBlockState(pos);
            Player player = pContext.getPlayer();
            if (player.canUseGameMasterBlocks() && state.isRandomlyTicking()) {
                state.randomTick(serverLevel, pos, serverLevel.random);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(pContext);
    }

    public boolean isFoil(ItemStack pStack) {
        return true;
    }
}

