/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class SanguineCoreItem
extends Item {
    protected static final List<SanguineCoreItem> CORES = new ArrayList<SanguineCoreItem>();
    protected final Supplier<EntityType<?>> typeSupplier;
    protected final int soulsPerSpawn;

    public SanguineCoreItem(Supplier<EntityType<?>> typeSupplier, int soulsPerSpawn, Item.Properties properties) {
        super(properties);
        this.typeSupplier = typeSupplier;
        this.soulsPerSpawn = soulsPerSpawn;
        CORES.add(this);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.sanguine_core.1", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue() + 1}));
        tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.sanguine_core.2", (Object[])new Object[]{this.soulsPerSpawn}));
    }

    public EntityType<?> getEntityType() {
        return this.typeSupplier.get();
    }

    public int getSoulsPerSpawn() {
        return this.soulsPerSpawn;
    }

    public static Collection<SanguineCoreItem> getAllCores() {
        return Collections.unmodifiableCollection(CORES);
    }
}

