/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class RuneItem
extends Item {
    protected static final Map<Rune, Item> RUNES = new HashMap<Rune, Item>();
    protected final Rune rune;

    public RuneItem(@Nonnull Rune rune) {
        super(new Item.Properties().rarity(rune.getRarity()));
        this.rune = rune;
        RuneItem.register(rune, this);
    }

    public Rune getRune() {
        return this.rune;
    }

    public boolean isFoil(ItemStack stack) {
        if (stack != null && stack.getItem() instanceof RuneItem) {
            return ((RuneItem)stack.getItem()).rune.hasGlint();
        }
        return super.isFoil(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        Item item;
        if (stack != null && (item = stack.getItem()) instanceof RuneItem) {
            RuneItem runeItem = (RuneItem)item;
            String key = String.join((CharSequence)".", "item", "primalmagick", Services.ITEMS_REGISTRY.getKey(this).getPath(), "tooltip");
            tooltip.add((Component)Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            if (runeItem.rune.hasLimit()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.rune_limit", (Object[])new Object[]{runeItem.rune.getLimit()}));
            }
        }
    }

    protected static void register(@Nonnull Rune rune, @Nonnull Item item) {
        RUNES.put(rune, item);
    }

    @Nonnull
    public static ItemStack getRune(@Nullable Rune rune) {
        return RuneItem.getRune(rune, 1);
    }

    @Nonnull
    public static ItemStack getRune(@Nullable Rune rune, int count) {
        Item item = RUNES.get(rune);
        return item == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item, count);
    }

    public static Collection<Item> getAllRunes() {
        return Collections.unmodifiableCollection(RUNES.values());
    }
}

