/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;

public class RecallStoneItem
extends Item {
    public RecallStoneItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverLevel.dimension().equals(serverPlayer.getRespawnDimension())) {
                    DimensionTransition respawn = serverPlayer.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.DO_NOTHING);
                    serverPlayer.teleportTo(serverLevel, respawn.pos().x(), respawn.pos().y(), respawn.pos().z(), respawn.yRot(), respawn.xRot());
                    serverPlayer.connection.send((Packet)new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
                    if (!player.hasInfiniteMaterials()) {
                        player.getItemInHand(hand).shrink(1);
                    }
                    CriteriaTriggersPM.RECALL_STONE.get().trigger(serverPlayer, (ResourceKey<Level>)serverLevel.dimension());
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.recall_stone.cannot_cross_dimensions").withStyle(ChatFormatting.RED), true);
                }
            }
        }
        return super.use(level, player, hand);
    }
}

