/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenGrimoireScreenPacket;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GrimoireItem
extends Item {
    private final boolean unlockAll;

    public GrimoireItem(boolean unlockAll, Item.Properties properties) {
        super(properties);
        this.unlockAll = unlockAll;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.isClientSide && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (this.unlockAll) {
                ResearchManager.forceGrantAll(playerIn);
            }
            StatsManager.incrementValue(playerIn, StatsPM.GRIMOIRE_READ);
            PacketHandler.sendToPlayer(new OpenGrimoireScreenPacket(), serverPlayer);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        if (this.unlockAll) {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }
}

