/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ForbiddenSourceGainItem
extends Item {
    protected final Source source;

    public ForbiddenSourceGainItem(Source source, Item.Properties properties) {
        super(properties);
        this.source = source;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            if (ResearchManager.isResearchStarted(player, ResearchEntries.FIRST_STEPS)) {
                if (!this.source.isDiscovered(player)) {
                    this.source.getDiscoverKey().ifPresent(key -> ResearchManager.completeResearch(player, key));
                    player.displayClientMessage((Component)Component.translatable((String)("event." + this.source.getId().getNamespace() + ".discover_source." + this.source.getId().getPath() + ".alternate")).withStyle(ChatFormatting.GREEN), false);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PacketHandler.sendToPlayer(new PlayClientSoundPacket(SoundsPM.WRITING.get(), 1.0f, 1.0f + (float)player.getRandom().nextGaussian() * 0.05f), serverPlayer);
                    }
                    if (!player.getAbilities().instabuild) {
                        player.getItemInHand(hand).shrink(1);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.knowledge_item.already_known").withStyle(ChatFormatting.RED), true);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.knowledge_item.failure").withStyle(ChatFormatting.RED), true);
            }
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        String translationKey = "item.primalmagick." + Services.ITEMS_REGISTRY.getKey(this).getPath() + ".tooltip";
        tooltip.add((Component)Component.translatable((String)translationKey).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }
}

