/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DreamVisionTalismanItem
extends Item {
    protected static final int CAPACITY = 64;

    public DreamVisionTalismanItem() {
        super(new Item.Properties().durability(64));
    }

    public int getStoredExp(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentsPM.STORED_EXPERIENCE.get(), (Object)0);
    }

    public int addStoredExp(ItemStack stack, int toAdd) {
        int max;
        int current = this.getStoredExp(stack);
        if (current + toAdd <= (max = this.getExpCapacity(stack))) {
            this.setStoredExp(stack, current + toAdd);
            return 0;
        }
        int leftover = current + toAdd - max;
        this.setStoredExp(stack, max);
        return leftover;
    }

    protected void setStoredExp(ItemStack stack, int toSet) {
        stack.set(DataComponentsPM.STORED_EXPERIENCE.get(), (Object)toSet);
    }

    public int getExpCapacity(ItemStack stack) {
        return 64;
    }

    public boolean isActive(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentsPM.ENABLED.get(), (Object)true);
    }

    public void setActive(ItemStack stack, boolean active) {
        stack.set(DataComponentsPM.ENABLED.get(), (Object)active);
    }

    public boolean isReadyToDrain(ItemStack stack) {
        DreamVisionTalismanItem talisman;
        Item item;
        return stack != null && (item = stack.getItem()) instanceof DreamVisionTalismanItem && (talisman = (DreamVisionTalismanItem)item).getStoredExp(stack) >= talisman.getExpCapacity(stack);
    }

    public boolean doDrain(ItemStack stack, Player player) {
        Level level = player.level();
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isReadyToDrain(stack) && ResearchManager.addKnowledge(player, KnowledgeType.OBSERVATION, KnowledgeType.OBSERVATION.getProgression())) {
                ServerPlayer serverPlayer;
                this.setStoredExp(stack, 0);
                stack.hurtAndBreak(1, serverLevel, player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null, item -> player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.dream_vision_talisman.break").withStyle(ChatFormatting.RED), false));
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.dream_vision_talisman.exp", (Object[])new Object[]{this.getStoredExp(stack), this.getExpCapacity(stack)}));
        if (this.isActive(stack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.active").withStyle(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.inactive").withStyle(ChatFormatting.RED));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return this.isReadyToDrain(stack) || super.isFoil(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        boolean active = this.isActive(stack);
        if (level.isClientSide) {
            if (active) {
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.dream_vision_talisman.set_inactive"), false);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.dream_vision_talisman.set_active"), false);
            }
        }
        this.setActive(stack, !active);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }
}

