/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.verdantartifice.primalmagick.common.entities.pixies.PixieRank;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrainedPixieItem
extends Item {
    protected static final Table<PixieRank, Source, DrainedPixieItem> PIXIES = HashBasedTable.create();
    private final PixieRank rank;
    private final Source source;

    public DrainedPixieItem(@NotNull PixieRank rank, @NotNull Source source, Item.Properties pProperties) {
        super(pProperties);
        this.rank = rank;
        this.source = source;
        DrainedPixieItem.register(rank, source, this);
    }

    @NotNull
    public PixieRank getPixieRank() {
        return this.rank;
    }

    @NotNull
    public Source getPixieSource() {
        return this.source;
    }

    protected static void register(@NotNull PixieRank rank, @NotNull Source source, @NotNull DrainedPixieItem item) {
        PIXIES.put((Object)rank, (Object)source, (Object)item);
    }

    @NotNull
    public static ItemStack getDrainedPixie(@Nullable PixieRank rank, @Nullable Source source) {
        return DrainedPixieItem.getDrainedPixie(rank, source, 1);
    }

    @NotNull
    public static ItemStack getDrainedPixie(@Nullable PixieRank rank, @Nullable Source source, int count) {
        Item item = (Item)PIXIES.get((Object)rank, (Object)source);
        return item == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item, count);
    }

    public static Collection<DrainedPixieItem> getAllDrainedPixies() {
        return Collections.unmodifiableCollection(PIXIES.values());
    }
}

