/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.blocks.rituals.OfferingPedestalBlock;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import com.verdantartifice.primalmagick.common.mana.network.Route;
import com.verdantartifice.primalmagick.common.mana.network.RouteManager;
import com.verdantartifice.primalmagick.common.mana.network.RouteTable;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.ManaSparklePacket;
import com.verdantartifice.primalmagick.common.network.packets.fx.PropMarkerPacket;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropTileEntity;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import com.verdantartifice.primalmagick.common.tiles.rituals.OfferingPedestalTileEntity;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualAltarTileEntity;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DowsingRodItem
extends Item {
    protected static final float THRESHOLD_HIGH = 0.15f;
    protected static final float THRESHOLD_LOW = 0.025f;

    public DowsingRodItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockPos targetPos = context.getClickedPos();
        this.recordDowsingPosition(stack, player, targetPos);
        if (!level.isClientSide) {
            Block block = level.getBlockState(targetPos).getBlock();
            BlockEntity blockEntity = level.getBlockEntity(targetPos);
            if (blockEntity instanceof RitualAltarTileEntity) {
                RitualAltarTileEntity altarEntity = (RitualAltarTileEntity)blockEntity;
                this.doStabilityCheck(altarEntity, player);
                this.damageRod(player, stack);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (block instanceof OfferingPedestalBlock) {
                OfferingPedestalBlock pedestalBlock = (OfferingPedestalBlock)block;
                if (blockEntity instanceof OfferingPedestalTileEntity) {
                    OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)blockEntity;
                    this.doPropSaltCheck(level, pedestalBlock, targetPos, player);
                    this.doPropSymmetryCheck(level, pedestalBlock, targetPos, pedestalTile.getAltarPos(), player);
                    this.damageRod(player, stack);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
            if (block instanceof IRitualPropBlock) {
                IRitualPropBlock propBlock = (IRitualPropBlock)block;
                if (blockEntity instanceof IRitualPropTileEntity) {
                    IRitualPropTileEntity propTile = (IRitualPropTileEntity)blockEntity;
                    this.doPropSaltCheck(level, propBlock, targetPos, player);
                    this.doPropSymmetryCheck(level, propBlock, targetPos, propTile.getAltarPos(), player);
                    this.damageRod(player, stack);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
            if (blockEntity instanceof IManaNetworkNode) {
                IManaNetworkNode node = (IManaNetworkNode)blockEntity;
                this.doRouteTableCheck(level, node, player, stack);
                this.damageRod(player, stack);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        InteractionResultHolder retVal = super.use(pLevel, pPlayer, pUsedHand);
        this.recordDowsingPosition(pPlayer.getItemInHand(pUsedHand), pPlayer, null);
        return retVal;
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pIsSelected) {
            BlockEntity blockEntity;
            BlockPos primaryPos;
            BlockPos blockPos = primaryPos = pStack.has(DataComponentsPM.DOWSING_PRIMARY_POSITION.get()) ? (BlockPos)pStack.get(DataComponentsPM.DOWSING_PRIMARY_POSITION.get()) : null;
            if (primaryPos != null && (blockEntity = pLevel.getBlockEntity(primaryPos)) instanceof IManaNetworkNode) {
                BlockPos secondaryPos;
                IManaNetworkNode primaryNode = (IManaNetworkNode)blockEntity;
                RouteTable routeTable = RouteManager.getRouteTable(pLevel);
                Set<Route.Hop> connectedHops = routeTable.getAllRoutes(pLevel, Optional.empty(), primaryNode).stream().map(r -> r.getHops(pLevel)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
                HashSet highlightedHops = new HashSet();
                BlockPos blockPos2 = secondaryPos = pStack.has(DataComponentsPM.DOWSING_SECONDARY_POSITION.get()) ? (BlockPos)pStack.get(DataComponentsPM.DOWSING_SECONDARY_POSITION.get()) : null;
                if (secondaryPos != null && primaryNode instanceof IManaConsumer) {
                    IManaConsumer consumer = (IManaConsumer)primaryNode;
                    BlockEntity blockEntity2 = pLevel.getBlockEntity(secondaryPos);
                    if (blockEntity2 instanceof IManaSupplier) {
                        IManaSupplier supplier = (IManaSupplier)blockEntity2;
                        Optional<Route> routeOpt = routeTable.getRoute(pLevel, Optional.empty(), supplier, consumer);
                        routeOpt.ifPresent(route -> {
                            List<Route.Hop> toHighlight = route.getHops(pLevel);
                            if (toHighlight != null && !toHighlight.isEmpty()) {
                                highlightedHops.addAll(toHighlight);
                                toHighlight.forEach(connectedHops::remove);
                            }
                        });
                    }
                }
                if (pEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pEntity;
                    connectedHops.forEach(hop -> this.showParticlesForRouteHop(serverPlayer, (Route.Hop)hop, Color.WHITE.getRGB()));
                    highlightedHops.forEach(hop -> this.showParticlesForRouteHop(serverPlayer, (Route.Hop)hop, Color.RED.getRGB()));
                }
            }
        }
    }

    protected void showParticlesForRouteHop(ServerPlayer serverPlayer, Route.Hop hop, int color) {
        PacketHandler.sendToPlayer(new ManaSparklePacket((Position)hop.supplier().getBlockPos().getCenter(), (Position)hop.consumer().getBlockPos().getCenter(), 20, color, 0.0), serverPlayer);
    }

    protected void recordDowsingPosition(@NotNull ItemStack stack, @Nullable Player player, @Nullable BlockPos targetPos) {
        boolean sendStatusMessage;
        boolean bl = sendStatusMessage = player != null && !player.level().isClientSide;
        if (targetPos == null && player != null && player.isShiftKeyDown()) {
            stack.remove(DataComponentsPM.DOWSING_PRIMARY_POSITION.get());
            stack.remove(DataComponentsPM.DOWSING_SECONDARY_POSITION.get());
            if (sendStatusMessage) {
                player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.position.clear"));
            }
        } else if (targetPos != null) {
            if (stack.has(DataComponentsPM.DOWSING_PRIMARY_POSITION.get())) {
                stack.set(DataComponentsPM.DOWSING_SECONDARY_POSITION.get(), (Object)((BlockPos)stack.get(DataComponentsPM.DOWSING_PRIMARY_POSITION.get())));
            }
            stack.set(DataComponentsPM.DOWSING_PRIMARY_POSITION.get(), (Object)targetPos);
            if (sendStatusMessage) {
                MutableComponent posText = ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)targetPos.toShortString()));
                player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.position.record", (Object[])new Object[]{posText}));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doRouteTableCheck(@NotNull Level level, @NotNull IManaNetworkNode primaryNode, @NotNull Player player, @NotNull ItemStack stack) {
        BlockPos secondaryPos = stack.has(DataComponentsPM.DOWSING_SECONDARY_POSITION.get()) ? (BlockPos)stack.get(DataComponentsPM.DOWSING_SECONDARY_POSITION.get()) : null;
        player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.mana_network.routes", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)primaryNode.getBlockPos().toShortString()))}));
        if (secondaryPos == null) return;
        BlockEntity blockEntity = level.getBlockEntity(secondaryPos);
        if (!(blockEntity instanceof IManaNetworkNode)) return;
        IManaNetworkNode secondaryNode = (IManaNetworkNode)blockEntity;
        if (secondaryNode instanceof IManaSupplier) {
            IManaConsumer consumer;
            IManaSupplier supplier = (IManaSupplier)secondaryNode;
            if (primaryNode instanceof IManaConsumer && (consumer = (IManaConsumer)primaryNode).getRouteTable().getRoute(level, Optional.empty(), supplier, consumer).isPresent()) {
                player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.mana_network.route_highlight", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)secondaryPos.toShortString())), ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)primaryNode.getBlockPos().toShortString()))}));
                return;
            }
        }
        player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.mana_network.no_route", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)secondaryPos.toShortString())), ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)primaryNode.getBlockPos().toShortString()))}));
    }

    protected void doStabilityCheck(RitualAltarTileEntity altarEntity, Player player) {
        float delta = altarEntity.calculateStabilityDelta();
        if (delta >= 0.15f) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.altar_stability.very_good"));
        } else if (delta >= 0.025f) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.altar_stability.good"));
        } else if (delta <= -0.15f) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.altar_stability.very_poor"));
        } else if (delta <= -0.025f) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.altar_stability.poor"));
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.altar_stability.neutral"));
        }
    }

    protected void doPropSaltCheck(Level level, ISaltPowered block, BlockPos blockPos, Player player) {
        if (block.isBlockSaltPowered((BlockGetter)level, blockPos)) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.salt_connection.active"));
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.salt_connection.inactive"));
        }
    }

    protected void doPropSymmetryCheck(Level level, IRitualStabilizer block, BlockPos blockPos, BlockPos altarPos, Player player) {
        BlockPos symPos = RitualAltarTileEntity.getSymmetricPosition(altarPos, blockPos);
        if (symPos == null || block.hasSymmetryPenalty(level, blockPos, symPos)) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.symmetry.not_found"));
            if (!level.isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.symmetry.marking_pos"));
                PacketHandler.sendToPlayer(new PropMarkerPacket(symPos, 200), serverPlayer);
            }
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.dowsing_rod.symmetry.found"));
        }
    }

    protected void damageRod(Player player, ItemStack stack) {
        if (!player.getAbilities().instabuild) {
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }
}

