/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class AbstractAttunementGainItem
extends Item {
    protected final Source source;
    protected final AttunementType attunementType;
    protected final int amount;

    public AbstractAttunementGainItem(Source source, AttunementType type, int amount, Item.Properties properties) {
        super(properties);
        this.source = source;
        this.attunementType = type;
        this.amount = amount;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            if (ResearchManager.hasStartedProgression(player)) {
                AttunementManager.incrementAttunement(player, this.source, this.attunementType, this.amount);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.attunement_item.success").withStyle(ChatFormatting.GREEN), true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketHandler.sendToPlayer(new PlayClientSoundPacket(SoundsPM.SHIMMER.get(), 1.0f, 1.0f + (float)player.getRandom().nextGaussian() * 0.05f), serverPlayer);
                }
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.attunement_item.failure").withStyle(ChatFormatting.RED), true);
            }
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String translationKey = "item.primalmagick." + Services.ITEMS_REGISTRY.getKey(this).getPath() + ".tooltip";
        tooltip.add((Component)Component.translatable((String)translationKey).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public int getColor(int tintIndex) {
        return tintIndex == 0 ? 0xFFFFFF : this.source.getColor();
    }
}

