/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.food;

import com.verdantartifice.primalmagick.common.items.food.FoodsPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sources.Sources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BloodyFleshItem
extends Item {
    public BloodyFleshItem() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON).food(FoodsPM.BLOODY_FLESH));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player player;
        if (!worldIn.isClientSide && entityLiving instanceof Player && ResearchManager.isResearchStarted(player = (Player)entityLiving, ResearchEntries.FIRST_STEPS) && !ResearchManager.isResearchStarted(player, ResearchEntries.DISCOVER_BLOOD)) {
            ResearchManager.completeResearch(player, ResearchEntries.DISCOVER_BLOOD);
            player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.discover_source.blood").withStyle(ChatFormatting.GREEN), false);
        }
        return super.finishUsingItem(stack, worldIn, entityLiving);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"item.primalmagick.bloody_flesh.tooltip.1").withStyle(new ChatFormatting[]{Sources.BLOOD.getChatColor(), ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"item.primalmagick.bloody_flesh.tooltip.2").withStyle(new ChatFormatting[]{Sources.BLOOD.getChatColor(), ChatFormatting.ITALIC}));
    }
}

