/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.essence;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;

public enum EssenceType implements StringRepresentable
{
    DUST("dust", Rarity.COMMON, 5, 100),
    SHARD("shard", Rarity.UNCOMMON, 20, 1000),
    CRYSTAL("crystal", Rarity.RARE, 50, 10000),
    CLUSTER("cluster", Rarity.EPIC, 100, 100000);

    private final String name;
    private final Rarity rarity;
    private final int affinity;
    private final int mana;

    private EssenceType(String name, Rarity rarity, int affinity, int mana) {
        this.name = name;
        this.rarity = rarity;
        this.affinity = affinity;
        this.mana = mana;
    }

    @Nonnull
    public String getSerializedName() {
        return this.name;
    }

    @Nonnull
    public Rarity getRarity() {
        return this.rarity;
    }

    public int getAffinity() {
        return this.affinity;
    }

    public int getManaEquivalent() {
        return this.mana;
    }

    public Optional<EssenceType> getUpgrade() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Optional.of(SHARD);
            case 1 -> Optional.of(CRYSTAL);
            case 2 -> Optional.of(CLUSTER);
            case 3 -> Optional.empty();
        };
    }

    public Optional<ResourceKey<ResearchEntry>> getUpgradeResearchEntry() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Optional.of(ResearchEntries.SHARD_SYNTHESIS);
            case 1 -> Optional.of(ResearchEntries.CRYSTAL_SYNTHESIS);
            case 2 -> Optional.of(ResearchEntries.CLUSTER_SYNTHESIS);
            case 3 -> Optional.empty();
        };
    }

    public Optional<EssenceType> getDowngrade() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> Optional.of(CRYSTAL);
            case 2 -> Optional.of(SHARD);
            case 1 -> Optional.of(DUST);
            case 0 -> Optional.empty();
        };
    }

    public Optional<ResourceKey<ResearchEntry>> getDowngradeResearchEntry() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> Optional.of(ResearchEntries.CLUSTER_DESYNTHESIS);
            case 2 -> Optional.of(ResearchEntries.CRYSTAL_DESYNTHESIS);
            case 1 -> Optional.of(ResearchEntries.SHARD_DESYNTHESIS);
            case 0 -> Optional.empty();
        };
    }

    public Optional<Item> getUpgradeMedium() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> Optional.of(Items.QUARTZ_BLOCK);
            case 2 -> Optional.of(Items.QUARTZ);
            case 1 -> Optional.of(ItemsPM.QUARTZ_NUGGET.get());
            case 0 -> Optional.empty();
        };
    }

    public boolean isDiscovered(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> new ResearchEntryKey(ResearchEntries.SHARD_SYNTHESIS).isKnownBy(player);
            case 2 -> new ResearchEntryKey(ResearchEntries.CRYSTAL_SYNTHESIS).isKnownBy(player);
            case 3 -> new ResearchEntryKey(ResearchEntries.CLUSTER_SYNTHESIS).isKnownBy(player);
        };
    }
}

