/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.entities;

import com.verdantartifice.primalmagick.client.renderers.itemstack.PixieHouseISTER;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.misc.PixieHouseEntity;
import com.verdantartifice.primalmagick.common.items.IHasCustomRenderer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class PixieHouseItem
extends Item
implements IHasCustomRenderer {
    private BlockEntityWithoutLevelRenderer customRenderer;

    public PixieHouseItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Direction direction = pContext.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = pContext.getLevel();
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(pContext);
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        ItemStack itemStack = pContext.getItemInHand();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB aabb = EntityTypesPM.PIXIE_HOUSE.get().getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
        if (level.noCollision(null, aabb) && level.getEntities(null, aabb).isEmpty()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)itemStack, (Player)pContext.getPlayer());
                PixieHouseEntity pixieHouse = (PixieHouseEntity)EntityTypesPM.PIXIE_HOUSE.get().create(serverLevel, consumer, blockPos, MobSpawnType.SPAWN_EGG, true, true);
                if (pixieHouse == null) {
                    return InteractionResult.FAIL;
                }
                float facing = (float)Mth.floor((float)((Mth.wrapDegrees((float)(pContext.getRotation() - 180.0f)) + 45.0f) / 90.0f)) * 90.0f;
                pixieHouse.moveTo(pixieHouse.getX(), pixieHouse.getY(), pixieHouse.getZ(), facing, 0.0f);
                serverLevel.addFreshEntityWithPassengers((Entity)pixieHouse);
                level.playSound(null, pixieHouse.getX(), pixieHouse.getY(), pixieHouse.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                pixieHouse.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)pContext.getPlayer());
            }
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplier() {
        if (this.customRenderer == null) {
            this.customRenderer = this.getCustomRendererSupplierUncached().get();
        }
        return () -> this.customRenderer;
    }

    @Override
    public Supplier<BlockEntityWithoutLevelRenderer> getCustomRendererSupplierUncached() {
        return PixieHouseISTER::new;
    }
}

