/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.entities;

import com.verdantartifice.primalmagick.common.entities.misc.FlyingCarpetEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FlyingCarpetItem
extends Item {
    public static final ResourceLocation COLOR_PROPERTY = ResourceUtils.loc("color");
    public static final CauldronInteraction DYED_CARPET = (state, level, pos, player, hand, stack) -> {
        Item item = stack.getItem();
        if (!(item instanceof FlyingCarpetItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FlyingCarpetItem carpet = (FlyingCarpetItem)item;
        if (carpet.getDyeColor(stack) == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            carpet.removeDyeColor(stack);
            LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    };

    public FlyingCarpetItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack dyeCarpet(ItemStack carpetStack, DyeItem dye) {
        Item item = carpetStack.getItem();
        if (item instanceof FlyingCarpetItem) {
            FlyingCarpetItem carpet = (FlyingCarpetItem)item;
            ItemStack retVal = carpetStack.copy();
            carpet.setDyeColor(retVal, dye.getDyeColor());
            return retVal;
        }
        return ItemStack.EMPTY;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide) {
            if (context.getClickedFace() != Direction.UP) {
                return InteractionResult.PASS;
            }
            ItemStack stack = context.getItemInHand();
            double posX = context.getClickLocation().x;
            double posY = context.getClickLocation().y;
            double posZ = context.getClickLocation().z;
            FlyingCarpetEntity entityCarpet = new FlyingCarpetEntity(world, posX, posY, posZ);
            entityCarpet.setDyeColor(this.getDyeColor(stack));
            entityCarpet.setYRot(context.getPlayer().getYRot());
            world.addFreshEntity((Entity)entityCarpet);
            world.playSound(null, posX, posY, posZ, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            context.getPlayer().setItemInHand(context.getHand(), ItemStack.EMPTY);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public DyeColor getDyeColor(ItemStack stack) {
        if (stack.has(DataComponents.DYED_COLOR)) {
            return DyeColor.byFireworkColor((int)((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb());
        }
        return null;
    }

    public void setDyeColor(ItemStack stack, DyeColor color) {
        if (color == null) {
            return;
        }
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color.getFireworkColor(), true));
    }

    public void removeDyeColor(ItemStack stack) {
        stack.remove(DataComponents.DYED_COLOR);
    }
}

