/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.concoctions;

import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ConcoctionItem
extends Item {
    public static final CauldronInteraction FILL_EMPTY_CAULDRON = (state, level, pos, player, hand, stack) -> {
        if (stack.has(DataComponents.POTION_CONTENTS) && ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
            if (!level.isClientSide) {
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)ItemsPM.SKYGLASS_FLASK.get())));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.setBlockAndUpdate(pos, Blocks.WATER_CAULDRON.defaultBlockState());
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    };
    public static final CauldronInteraction FILL_WATER_CAULDRON = (state, level, pos, player, hand, stack) -> {
        if ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) < 3 && stack.has(DataComponents.POTION_CONTENTS) && ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
            if (!level.isClientSide) {
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)ItemsPM.SKYGLASS_FLASK.get())));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LayeredCauldronBlock.LEVEL));
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    };

    public ConcoctionItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getDefaultInstance() {
        return ConcoctionUtils.setConcoctionType(PotionContents.createItemStack((Item)this, (Holder)Potions.WATER), ConcoctionType.WATER);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (!worldIn.isClientSide) {
            PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            contents.forEachEffect(instance -> {
                if (((MobEffect)instance.getEffect().value()).isInstantenous()) {
                    ((MobEffect)instance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, entityLiving, instance.getAmplifier(), 1.0);
                } else {
                    entityLiving.addEffect(new MobEffectInstance(instance));
                }
            });
        }
        if (player != null) {
            StatsManager.incrementValue(player, StatsPM.CONCOCTIONS_USED);
            if (!player.getAbilities().instabuild) {
                int doses = ConcoctionUtils.getCurrentDoses(stack);
                if (doses <= 1) {
                    stack.shrink(1);
                } else {
                    ConcoctionUtils.setCurrentDoses(stack, doses - 1);
                }
            }
        }
        return stack.isEmpty() ? new ItemStack((ItemLike)ItemsPM.SKYGLASS_FLASK.get()) : stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity pEntity) {
        return 32;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        return ItemUtils.startUsingInstantly((Level)worldIn, (Player)playerIn, (InteractionHand)handIn);
    }

    public String getDescriptionId(ItemStack stack) {
        ConcoctionType type = ConcoctionUtils.getConcoctionType(stack);
        if (stack.has(DataComponents.POTION_CONTENTS) && type != null) {
            Optional potionHolderOpt = ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).potion();
            return Potion.getName((Optional)potionHolderOpt, (String)(this.getDescriptionId() + "." + type.getSerializedName() + ".effect."));
        }
        type = ConcoctionType.WATER;
        PotionContents fakeContents = new PotionContents(Potions.WATER);
        return Potion.getName((Optional)fakeContents.potion(), (String)(this.getDescriptionId() + "." + type.getSerializedName() + ".effect."));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        PotionContents.addPotionTooltip((Iterable)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getAllEffects(), tooltip::add, (float)1.0f, (float)context.tickRate());
        tooltip.add((Component)Component.translatable((String)"concoctions.primalmagick.doses_remaining", (Object[])new Object[]{ConcoctionUtils.getCurrentDoses(stack)}).withStyle(MobEffectCategory.BENEFICIAL.getTooltipFormatting()));
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects();
    }

    public static void registerCreativeTabItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output, Supplier<? extends ItemLike> itemSupplier) {
        Item item = itemSupplier.get().asItem();
        output.accept(item.getDefaultInstance());
        for (ConcoctionType concoctionType : ConcoctionType.values()) {
            if (!concoctionType.hasDrinkablePotion()) continue;
            params.holders().lookup(Registries.POTION).ifPresent(registryLookup -> registryLookup.listElements().filter(potionRef -> !((Potion)potionRef.value()).getEffects().isEmpty() && ConcoctionUtils.hasBeneficialEffect((Potion)potionRef.value())).map(potionRef -> ConcoctionUtils.setConcoctionType(PotionContents.createItemStack((Item)item, (Holder)potionRef), concoctionType)).forEach(stack -> output.accept(stack)));
        }
    }
}

