/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.concoctions;

import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.entities.projectiles.AlchemicalBombEntity;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AlchemicalBombItem
extends Item {
    public AlchemicalBombItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getDefaultInstance() {
        return ConcoctionUtils.setFuseType(ConcoctionUtils.setConcoctionType(PotionContents.createItemStack((Item)this, (Holder)Potions.WATER), ConcoctionType.WATER), FuseType.MEDIUM);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isSecondaryUseActive()) {
            FuseType fuse = ConcoctionUtils.getFuseType(stack);
            if (!worldIn.isClientSide && fuse != null && fuse.getNext() != null) {
                playerIn.setItemInHand(handIn, ConcoctionUtils.setFuseType(stack, fuse.getNext()));
                MutableComponent fuseText = Component.translatable((String)fuse.getNext().getTranslationKey());
                playerIn.sendSystemMessage((Component)Component.translatable((String)"concoctions.primalmagick.fuse_set", (Object[])new Object[]{fuseText}));
            }
        } else {
            worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (worldIn.getRandom().nextFloat() * 0.4f + 0.8f));
            worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            AlchemicalBombEntity entity = new AlchemicalBombEntity(worldIn, (LivingEntity)playerIn);
            entity.setItem(stack);
            entity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), -20.0f, 0.5f, 1.0f);
            worldIn.addFreshEntity((Entity)entity);
            StatsManager.incrementValue(playerIn, StatsPM.CONCOCTIONS_USED);
            if (!playerIn.getAbilities().instabuild) {
                int charges = ConcoctionUtils.getCurrentDoses(stack);
                if (charges <= 1) {
                    stack.shrink(1);
                } else {
                    ConcoctionUtils.setCurrentDoses(stack, charges - 1);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)worldIn.isClientSide());
    }

    public String getDescriptionId(ItemStack stack) {
        ConcoctionType type = ConcoctionUtils.getConcoctionType(stack);
        if (stack.has(DataComponents.POTION_CONTENTS) && type != null) {
            Optional potionHolderOpt = ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).potion();
            return Potion.getName((Optional)potionHolderOpt, (String)(this.getDescriptionId() + "." + type.getSerializedName() + ".effect."));
        }
        type = ConcoctionType.WATER;
        PotionContents fakeContents = new PotionContents(Potions.WATER);
        return Potion.getName((Optional)fakeContents.potion(), (String)(this.getDescriptionId() + "." + type.getSerializedName() + ".effect."));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        PotionContents.addPotionTooltip((Iterable)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getAllEffects(), tooltip::add, (float)1.0f, (float)context.tickRate());
        tooltip.add((Component)Component.translatable((String)"concoctions.primalmagick.charges_remaining", (Object[])new Object[]{ConcoctionUtils.getCurrentDoses(stack)}).withStyle(MobEffectCategory.BENEFICIAL.getTooltipFormatting()));
        FuseType fuse = ConcoctionUtils.getFuseType(stack);
        if (fuse == null) {
            fuse = FuseType.MEDIUM;
        }
        MutableComponent fuseText = Component.translatable((String)fuse.getTranslationKey()).withStyle(MobEffectCategory.BENEFICIAL.getTooltipFormatting());
        tooltip.add((Component)Component.translatable((String)"concoctions.primalmagick.fuse_length", (Object[])new Object[]{fuseText}).withStyle(MobEffectCategory.BENEFICIAL.getTooltipFormatting()));
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects();
    }

    public static void registerCreativeTabItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output, Supplier<? extends ItemLike> itemSupplier) {
        Item item = itemSupplier.get().asItem();
        output.accept(item.getDefaultInstance());
        params.holders().lookup(Registries.POTION).ifPresent(registryLookup -> registryLookup.listElements().filter(potionRef -> !((Potion)potionRef.value()).getEffects().isEmpty()).map(potionRef -> ConcoctionUtils.setFuseType(ConcoctionUtils.setConcoctionType(PotionContents.createItemStack((Item)item, (Holder)potionRef), ConcoctionType.BOMB), FuseType.MEDIUM)).forEach(stack -> output.accept(stack)));
    }
}

