/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.concoctions;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractConcoctionContainerItem
extends Item {
    public AbstractConcoctionContainerItem(Item.Properties properties) {
        super(properties);
    }

    protected abstract ItemStack getConcoctionContainerItem();

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemStack = playerIn.getItemInHand(handIn);
        BlockHitResult rayTraceResult = AbstractConcoctionContainerItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos = rayTraceResult.getBlockPos();
            if (!worldIn.mayInteract(playerIn, blockPos)) {
                return InteractionResultHolder.pass((Object)itemStack);
            }
            if (worldIn.getFluidState(blockPos).is(FluidTags.WATER)) {
                worldIn.playSound(playerIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResultHolder.sidedSuccess((Object)this.turnFlaskIntoItem(itemStack, playerIn, this.getConcoctionContainerItem()), (boolean)worldIn.isClientSide());
            }
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    protected ItemStack turnFlaskIntoItem(ItemStack flaskStack, Player player, ItemStack stack) {
        return ItemUtils.createFilledResult((ItemStack)flaskStack, (Player)player, (ItemStack)stack);
    }
}

