/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.books;

import com.mojang.datafixers.util.Either;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookHelper;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BookType;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenStaticBookScreenPacket;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StaticBookItem
extends Item {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final String TAG_BOOK_ID = "BookId";
    public static final String TAG_BOOK_LANGUAGE_ID = "BookLanguageId";
    public static final String TAG_AUTHOR_OVERRIDE = "AuthorOverride";
    public static final String TAG_COMPREHENSION = "Comprehension";
    public static final String TAG_GENERATION = "Generation";
    public static final int MAX_GENERATION = 2;
    protected static final DecimalFormat COMPREHENSION_FORMATTER = new DecimalFormat("###.#");
    protected static final Map<BookType, StaticBookItem> TYPE_MAP = new HashMap<BookType, StaticBookItem>();
    protected final BookType bookType;

    public StaticBookItem(BookType type, Item.Properties properties) {
        super(properties);
        this.bookType = type;
        TYPE_MAP.put(type, this);
    }

    protected static MutableComponent getStaticAttribute(ResourceKey<BookDefinition> bookId, String attrName) {
        return Component.translatable((String)String.join((CharSequence)".", "written_book", bookId.location().getNamespace(), bookId.location().getPath().replace('/', '.'), attrName));
    }

    protected static Component getNameFromBookId(ResourceKey<BookDefinition> bookId) {
        return StaticBookItem.getStaticAttribute(bookId, "title");
    }

    protected static MutableComponent getAuthorFromBookId(ResourceKey<BookDefinition> bookId) {
        return StaticBookItem.getStaticAttribute(bookId, "author");
    }

    public static Optional<Holder<BookDefinition>> getBookDefinition(ItemStack stack) {
        return Optional.ofNullable((Holder)stack.get(DataComponentsPM.BOOK_DEFINITION.get()));
    }

    public static Optional<ResourceKey<BookDefinition>> getBookId(ItemStack stack) {
        return StaticBookItem.getBookDefinition(stack).flatMap(defHolder -> defHolder.unwrapKey());
    }

    public static boolean hasBookDefinition(ItemStack stack) {
        return StaticBookItem.getBookDefinition(stack).isPresent();
    }

    public static ItemStack setBookDefinition(ItemStack stack, Holder<BookDefinition> bookDef) {
        stack.set(DataComponentsPM.BOOK_DEFINITION.get(), bookDef);
        return stack;
    }

    public static Optional<Holder<BookLanguage>> getBookLanguage(ItemStack stack) {
        return Optional.ofNullable((Holder)stack.get(DataComponentsPM.BOOK_LANGUAGE.get()));
    }

    public static Optional<ResourceKey<BookLanguage>> getBookLanguageId(ItemStack stack) {
        return StaticBookItem.getBookLanguage(stack).flatMap(langHolder -> langHolder.unwrapKey());
    }

    public static boolean hasBookLanguage(ItemStack stack) {
        return StaticBookItem.getBookLanguage(stack).isPresent();
    }

    public static ItemStack setBookLanguage(ItemStack stack, Holder<BookLanguage> lang) {
        stack.set(DataComponentsPM.BOOK_LANGUAGE.get(), lang);
        return stack;
    }

    public static boolean hasAuthor(ItemStack stack) {
        return !StringUtil.isNullOrEmpty((String)((String)stack.get(DataComponentsPM.AUTHOR_OVERRIDE.get()))) || stack.has(DataComponentsPM.BOOK_DEFINITION.get());
    }

    public static Component getAuthor(ItemStack stack) {
        if (stack.has(DataComponentsPM.AUTHOR_OVERRIDE.get())) {
            return Component.literal((String)((String)stack.get(DataComponentsPM.AUTHOR_OVERRIDE.get())));
        }
        return (Component)StaticBookItem.getBookId(stack).map(StaticBookItem::getAuthorFromBookId).orElse(Component.translatable((String)"tooltip.primalmagick.written_book.author.unknown"));
    }

    public static ItemStack setAuthorOverride(ItemStack stack, String name) {
        stack.set(DataComponentsPM.AUTHOR_OVERRIDE.get(), (Object)name);
        return stack;
    }

    public static Optional<Integer> getTranslatedComprehension(ItemStack stack) {
        return Optional.ofNullable((Integer)stack.get(DataComponentsPM.TRANSLATED_COMPREHENSION.get()));
    }

    public static ItemStack setTranslatedComprehension(ItemStack stack, Optional<Integer> comprehensionOpt) {
        comprehensionOpt.ifPresentOrElse(comp -> stack.set(DataComponentsPM.TRANSLATED_COMPREHENSION.get(), comp), () -> stack.remove(DataComponentsPM.TRANSLATED_COMPREHENSION.get()));
        return stack;
    }

    public static int getGeneration(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentsPM.BOOK_GENERATION.get(), (Object)0);
    }

    public static ItemStack setGeneration(ItemStack stack, int newGeneration) {
        stack.set(DataComponentsPM.BOOK_GENERATION.get(), (Object)newGeneration);
        return stack;
    }

    public static BookView makeBookView(ItemStack pStack, HolderLookup.Provider registries) {
        Optional<Holder<BookLanguage>> langHolderOpt;
        Player player = Services.PLATFORM.isClientDist() ? ClientUtils.getCurrentPlayer() : null;
        Holder book = StaticBookItem.getBookDefinition(pStack).orElseGet(() -> registries.lookupOrThrow(RegistryKeysPM.BOOKS).getOrThrow(BooksPM.TEST_BOOK));
        Holder lang = StaticBookItem.getBookLanguage(pStack).orElseGet(() -> registries.lookupOrThrow(RegistryKeysPM.BOOK_LANGUAGES).getOrThrow(BookLanguagesPM.DEFAULT));
        int playerComprehension = 0;
        if (player != null && (langHolderOpt = StaticBookItem.getBookLanguage(pStack)).isPresent()) {
            playerComprehension = LinguisticsManager.getComprehension(player, langHolderOpt.get());
        }
        int comprehension = Math.max(playerComprehension, StaticBookItem.getTranslatedComprehension(pStack).orElse(0));
        return new BookView((Either<Holder<BookDefinition>, Holder<Enchantment>>)Either.left((Object)book), (Holder<BookLanguage>)lang, comprehension);
    }

    public Component getName(ItemStack pStack) {
        if (Services.PLATFORM.isClientDist() && StaticBookItem.getBookId(pStack).isPresent()) {
            RegistryAccess registries = ClientUtils.getCurrentLevel().registryAccess();
            return BookHelper.getTitleText(StaticBookItem.makeBookView(pStack, (HolderLookup.Provider)registries));
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        if (Services.PLATFORM.isClientDist() && StaticBookItem.hasAuthor(pStack)) {
            Component authorText = BookHelper.getAuthorText(StaticBookItem.makeBookView(pStack, pContext.registries()), StaticBookItem.getAuthor(pStack));
            pTooltipComponents.add((Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{authorText}).withStyle(ChatFormatting.GRAY));
        }
        StaticBookItem.getBookDefinition(pStack).ifPresent(defHolder -> StaticBookItem.getBookLanguage(pStack).ifPresent(langHolder -> {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.written_language.header", (Object[])new Object[]{((BookLanguage)langHolder.value()).getName()}).withStyle(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.translatable((String)("book.generation." + StaticBookItem.getGeneration(pStack))).withStyle(ChatFormatting.GRAY));
            if (Services.PLATFORM.isClientDist() && StaticBookItem.hasBookDefinition(pStack) && StaticBookItem.hasBookLanguage(pStack) && ((BookLanguage)langHolder.value()).isComplex()) {
                int timesStudied;
                Player player = Services.PLATFORM.isClientDist() ? ClientUtils.getCurrentPlayer() : null;
                Optional<Integer> translatedComprehension = StaticBookItem.getTranslatedComprehension(pStack);
                int comprehension = Math.max(translatedComprehension.orElse(0), LinguisticsManager.getComprehension(player, (Holder<BookLanguage>)langHolder));
                double percentage = BookHelper.getBookComprehension(new BookView((Either<Holder<BookDefinition>, Holder<Enchantment>>)Either.left((Object)defHolder), (Holder<BookLanguage>)langHolder, comprehension));
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.written_language.comprehension", (Object[])new Object[]{COMPREHENSION_FORMATTER.format(100.0 * percentage)}).withStyle(ChatFormatting.GRAY));
                if (translatedComprehension.isPresent()) {
                    if (translatedComprehension.get() >= ((BookLanguage)langHolder.value()).complexity()) {
                        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.written_language.translated.full").withStyle(ChatFormatting.DARK_AQUA));
                    } else if (translatedComprehension.get() > 0) {
                        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.written_language.translated.partial").withStyle(ChatFormatting.DARK_AQUA));
                    }
                }
                if ((timesStudied = LinguisticsManager.getTimesStudied(player, (Holder<BookDefinition>)defHolder, (Holder<BookLanguage>)langHolder)) > 0) {
                    pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.written_language.times_studied", (Object[])new Object[]{timesStudied}).withStyle(ChatFormatting.DARK_AQUA));
                }
            }
        }));
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            StaticBookItem.getBookDefinition(stack).ifPresentOrElse(bookDefHolder -> StaticBookItem.getBookLanguage(stack).ifPresentOrElse(langHolder -> {
                LinguisticsManager.markRead(pPlayer, (Holder<BookDefinition>)bookDefHolder, (Holder<BookLanguage>)langHolder);
                PacketHandler.sendToPlayer(new OpenStaticBookScreenPacket(stack, this.bookType, (HolderLookup.Provider)pLevel.registryAccess()), serverPlayer);
            }, () -> LOGGER.error("No book language found when opening static book stack {}", (Object)stack.toString())), () -> LOGGER.error("No book definition found when opening static book stack {}", (Object)stack.toString()));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static Builder builder(Supplier<StaticBookItem> baseBook, HolderLookup.Provider registries) {
        return new Builder(baseBook, registries);
    }

    public static class Builder {
        protected final HolderLookup.Provider registries;
        protected final Supplier<StaticBookItem> baseBook;
        protected Optional<ResourceKey<BookDefinition>> bookKeyOpt = Optional.empty();
        protected Optional<ResourceKey<BookLanguage>> langKeyOpt = Optional.empty();
        protected Optional<String> authorOpt = Optional.empty();
        protected Optional<Integer> generationOpt = Optional.empty();
        protected Optional<Integer> translationOpt = Optional.empty();

        protected Builder(Supplier<StaticBookItem> baseBook, HolderLookup.Provider registries) {
            this.baseBook = baseBook;
            this.registries = registries;
        }

        public Builder book(ResourceKey<BookDefinition> bookDef) {
            this.bookKeyOpt = Optional.ofNullable(bookDef);
            return this;
        }

        public Builder language(ResourceKey<BookLanguage> lang) {
            this.langKeyOpt = Optional.ofNullable(lang);
            return this;
        }

        public Builder author(String author) {
            this.authorOpt = Optional.ofNullable(author);
            return this;
        }

        public Builder generation(int gen) {
            this.generationOpt = Optional.of(gen);
            return this;
        }

        public Builder translation(int translation) {
            this.translationOpt = Optional.of(translation);
            return this;
        }

        public ItemStack build() {
            ItemStack retVal = new ItemStack((ItemLike)this.baseBook.get());
            this.bookKeyOpt.flatMap(bookKey -> this.registries.lookupOrThrow(RegistryKeysPM.BOOKS).get(bookKey)).ifPresent(bookDef -> StaticBookItem.setBookDefinition(retVal, (Holder<BookDefinition>)bookDef));
            this.langKeyOpt.flatMap(langKey -> this.registries.lookupOrThrow(RegistryKeysPM.BOOK_LANGUAGES).get(langKey)).ifPresent(lang -> StaticBookItem.setBookLanguage(retVal, (Holder<BookLanguage>)lang));
            this.authorOpt.ifPresent(author -> StaticBookItem.setAuthorOverride(retVal, author));
            this.generationOpt.ifPresent(gen -> StaticBookItem.setGeneration(retVal, gen));
            StaticBookItem.setTranslatedComprehension(retVal, this.translationOpt);
            return retVal;
        }
    }
}

