/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.armor;

import com.verdantartifice.primalmagick.common.armortrim.TrimPatternsPM;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.armor.IManaDiscountGear;
import com.verdantartifice.primalmagick.common.items.misc.RuneItem;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.SourceRune;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class RobeArmorItem
extends ArmorItem
implements IManaDiscountGear {
    public RobeArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    public int getManaDiscount(ItemStack stack, Player player, Source source) {
        int baseDiscount = (Integer)stack.getOrDefault(DataComponentsPM.MANA_DISCOUNT.get(), (Object)0);
        Optional<Source> sourceOpt = this.getAttunedSource(stack, player);
        if (sourceOpt.isPresent()) {
            if (sourceOpt.get().equals(source)) {
                return 2 * baseDiscount;
            }
            return 0;
        }
        return baseDiscount;
    }

    @Override
    public int getBestManaDiscount(ItemStack stack, Player player) {
        int baseDiscount = (Integer)stack.getOrDefault(DataComponentsPM.MANA_DISCOUNT.get(), (Object)0);
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        if (trim != null && trim.pattern().is(TrimPatternsPM.RUNIC)) {
            return 2 * baseDiscount;
        }
        return baseDiscount;
    }

    @Override
    public Optional<Source> getAttunedSource(ItemStack stack, Player player) {
        RuneItem runeItem;
        Rune rune;
        Item trimItem;
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        if (trim != null && trim.pattern().is(TrimPatternsPM.RUNIC) && (trimItem = (Item)((TrimMaterial)trim.material().value()).ingredient().value()) instanceof RuneItem && (rune = (runeItem = (RuneItem)trimItem).getRune()) instanceof SourceRune) {
            SourceRune sourceRune = (SourceRune)rune;
            return Optional.ofNullable(sourceRune.getSource());
        }
        return Optional.empty();
    }
}

