/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.armor;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.registries.IRegistryItem;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ArmorMaterialsPM {
    public static final IRegistryItem<ArmorMaterial, ArmorMaterial> IMBUED_WOOL = ArmorMaterialsPM.register("imbued_wool", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defMap -> {
        defMap.put(ArmorItem.Type.BOOTS, 1);
        defMap.put(ArmorItem.Type.LEGGINGS, 3);
        defMap.put(ArmorItem.Type.CHESTPLATE, 4);
        defMap.put(ArmorItem.Type.HELMET, 1);
        defMap.put(ArmorItem.Type.BODY, 3);
    }), 17, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, 0.0f, () -> Ingredient.of((TagKey)ItemTags.WOOL));
    public static final IRegistryItem<ArmorMaterial, ArmorMaterial> SPELLCLOTH = ArmorMaterialsPM.register("spellcloth", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defMap -> {
        defMap.put(ArmorItem.Type.BOOTS, 2);
        defMap.put(ArmorItem.Type.LEGGINGS, 5);
        defMap.put(ArmorItem.Type.CHESTPLATE, 7);
        defMap.put(ArmorItem.Type.HELMET, 2);
        defMap.put(ArmorItem.Type.BODY, 6);
    }), 22, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemsPM.SPELLCLOTH.get()}));
    public static final IRegistryItem<ArmorMaterial, ArmorMaterial> HEXWEAVE = ArmorMaterialsPM.register("hexweave", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defMap -> {
        defMap.put(ArmorItem.Type.BOOTS, 3);
        defMap.put(ArmorItem.Type.LEGGINGS, 7);
        defMap.put(ArmorItem.Type.CHESTPLATE, 9);
        defMap.put(ArmorItem.Type.HELMET, 3);
        defMap.put(ArmorItem.Type.BODY, 8);
    }), 27, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 2.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemsPM.HEXWEAVE.get()}));
    public static final IRegistryItem<ArmorMaterial, ArmorMaterial> SAINTSWOOL = ArmorMaterialsPM.register("saintswool", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defMap -> {
        defMap.put(ArmorItem.Type.BOOTS, 4);
        defMap.put(ArmorItem.Type.LEGGINGS, 8);
        defMap.put(ArmorItem.Type.CHESTPLATE, 10);
        defMap.put(ArmorItem.Type.HELMET, 4);
        defMap.put(ArmorItem.Type.BODY, 10);
    }), 32, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 3.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemsPM.SAINTSWOOL.get()}));
    public static final IRegistryItem<ArmorMaterial, ArmorMaterial> PRIMALITE = ArmorMaterialsPM.register("primalite", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defMap -> {
        defMap.put(ArmorItem.Type.BOOTS, 3);
        defMap.put(ArmorItem.Type.LEGGINGS, 5);
        defMap.put(ArmorItem.Type.CHESTPLATE, 7);
        defMap.put(ArmorItem.Type.HELMET, 3);
        defMap.put(ArmorItem.Type.BODY, 7);
    }), 18, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 1.0f, 0.0f, () -> Ingredient.of(ItemTagsPM.INGOTS_PRIMALITE));
    public static final IRegistryItem<ArmorMaterial, ArmorMaterial> HEXIUM = ArmorMaterialsPM.register("hexium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defMap -> {
        defMap.put(ArmorItem.Type.BOOTS, 4);
        defMap.put(ArmorItem.Type.LEGGINGS, 7);
        defMap.put(ArmorItem.Type.CHESTPLATE, 9);
        defMap.put(ArmorItem.Type.HELMET, 4);
        defMap.put(ArmorItem.Type.BODY, 11);
    }), 23, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 2.0f, 0.1f, () -> Ingredient.of(ItemTagsPM.INGOTS_HEXIUM));
    public static final IRegistryItem<ArmorMaterial, ArmorMaterial> HALLOWSTEEL = ArmorMaterialsPM.register("hallowsteel", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defMap -> {
        defMap.put(ArmorItem.Type.BOOTS, 5);
        defMap.put(ArmorItem.Type.LEGGINGS, 8);
        defMap.put(ArmorItem.Type.CHESTPLATE, 10);
        defMap.put(ArmorItem.Type.HELMET, 5);
        defMap.put(ArmorItem.Type.BODY, 14);
    }), 28, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, 3.0f, 0.2f, () -> Ingredient.of(ItemTagsPM.INGOTS_HALLOWSTEEL));

    public static void init() {
        Services.ARMOR_MATERIALS_REGISTRY.init();
    }

    private static IRegistryItem<ArmorMaterial, ArmorMaterial> register(String pName, EnumMap<ArmorItem.Type, Integer> pDefense, int pEnchantmentValue, Holder<SoundEvent> pEquipSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(ResourceUtils.loc(pName)));
        return ArmorMaterialsPM.register(pName, pDefense, pEnchantmentValue, pEquipSound, pToughness, pKnockbackResistance, pRepairIngredient, list);
    }

    private static IRegistryItem<ArmorMaterial, ArmorMaterial> register(String pName, EnumMap<ArmorItem.Type, Integer> pDefense, int pEnchantmentValue, Holder<SoundEvent> pEquipSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient, List<ArmorMaterial.Layer> pLayers) {
        EnumMap<ArmorItem.Type, Integer> defenseMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type armorType : ArmorItem.Type.values()) {
            defenseMap.put(armorType, pDefense.get(armorType));
        }
        return Services.ARMOR_MATERIALS_REGISTRY.register(pName, () -> new ArmorMaterial((Map)defenseMap, pEnchantmentValue, pEquipSound, pRepairIngredient, pLayers, pToughness, pKnockbackResistance));
    }
}

