/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.mana.network.RouteManager;
import com.verdantartifice.primalmagick.common.misc.BlockBreaker;
import com.verdantartifice.primalmagick.common.misc.BlockSwapper;
import java.util.Queue;
import net.minecraft.world.level.Level;

public class ServerEvents {
    public static void serverLevelTick(Level level) {
        ServerEvents.tickBlockSwappers(level);
        ServerEvents.tickBlockBreakers(level);
        ServerEvents.tickRouteTables(level);
    }

    protected static void tickBlockSwappers(Level level) {
        Queue<BlockSwapper> swapperQueue = BlockSwapper.getWorldSwappers(level);
        while (!swapperQueue.isEmpty()) {
            BlockSwapper swapper = swapperQueue.poll();
            if (swapper == null) continue;
            swapper.execute(level);
        }
    }

    protected static void tickBlockBreakers(Level level) {
        Iterable<BlockBreaker> breakers = BlockBreaker.tick(level);
        for (BlockBreaker breaker : breakers) {
            BlockBreaker newBreaker = breaker.execute(level);
            if (newBreaker == null) continue;
            BlockBreaker.schedule(level, 1, newBreaker);
        }
    }

    protected static void tickRouteTables(Level level) {
        RouteManager.getRouteTable(level).tick(level);
    }
}

