/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.mojang.datafixers.util.Pair;
import com.verdantartifice.primalmagick.common.attunements.AttunementAttributeModifiers;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.misc.GlowFieldBlock;
import com.verdantartifice.primalmagick.common.blockstates.properties.TimePhase;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.items.misc.DreamVisionTalismanItem;
import com.verdantartifice.primalmagick.common.misc.EntitySwapper;
import com.verdantartifice.primalmagick.common.misc.InteractionRecord;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.ResetFallDistancePacket;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.keys.ResearchStageKey;
import com.verdantartifice.primalmagick.common.research.keys.StackCraftedKey;
import com.verdantartifice.primalmagick.common.research.keys.TagCraftedKey;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.VisibleForTesting;

public class PlayerEvents {
    public static final Map<UUID, InteractionRecord> LAST_BLOCK_LEFT_CLICK = new HashMap<UUID, InteractionRecord>();
    private static final Map<UUID, Boolean> DOUBLE_JUMP_ALLOWED = new HashMap<UUID, Boolean>();
    private static final Set<UUID> NEAR_DEATH_ELIGIBLE = new HashSet<UUID>();
    private static final AttributeModifier STEP_MODIFIER_EARTH = new AttributeModifier(AttunementAttributeModifiers.EARTH_GREATER_ID, 0.4, AttributeModifier.Operation.ADD_VALUE);
    private static final ResearchStageKey SOURCE_EARTH_START = new ResearchStageKey(ResearchEntries.SOURCE_EARTH, 1);
    private static final ResearchStageKey SOURCE_EARTH_END = new ResearchStageKey(ResearchEntries.SOURCE_EARTH, 2);
    private static final ResearchStageKey SOURCE_SEA_START = new ResearchStageKey(ResearchEntries.SOURCE_SEA, 1);
    private static final ResearchStageKey SOURCE_SEA_END = new ResearchStageKey(ResearchEntries.SOURCE_SEA, 2);
    private static final ResearchStageKey SOURCE_SKY_START = new ResearchStageKey(ResearchEntries.SOURCE_SKY, 1);
    private static final ResearchStageKey SOURCE_SKY_END = new ResearchStageKey(ResearchEntries.SOURCE_SKY, 2);
    private static final ResearchStageKey SOURCE_SUN_START = new ResearchStageKey(ResearchEntries.SOURCE_SUN, 1);
    private static final ResearchStageKey SOURCE_SUN_END = new ResearchStageKey(ResearchEntries.SOURCE_SUN, 2);
    private static final ResearchStageKey SOURCE_MOON_START = new ResearchStageKey(ResearchEntries.SOURCE_MOON, 1);
    private static final ResearchStageKey SOURCE_MOON_END = new ResearchStageKey(ResearchEntries.SOURCE_MOON, 2);
    private static final Logger LOGGER = LogManager.getLogger();

    public static void livingTick(Entity entity) {
        ServerPlayer player;
        Level level = entity.level();
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            PlayerEvents.checkNearDeathExperience(player);
            if (player.tickCount % 5 == 0) {
                PlayerEvents.applyAttunementBuffs(player);
                PlayerEvents.refreshWeakenedSoul(player);
            }
            if (player.tickCount % 10 == 0) {
                PlayerEvents.doScheduledSyncs(player, false);
            }
            if (player.tickCount % 20 == 0) {
                PlayerEvents.handleLightDrop(player, level.random);
                PlayerEvents.handleRegrowth((Player)player);
                PlayerEvents.handleWardRegeneration(player);
            }
            if (player.tickCount % 200 == 0) {
                PlayerEvents.checkEnvironmentalResearch(player);
                PlayerEvents.handlePhotosynthesis(player);
            }
            if (player.tickCount % 1200 == 0) {
                AttunementManager.decayTemporaryAttunements((Player)player);
            }
        }
        if (level.isClientSide && entity instanceof Player) {
            player = (Player)entity;
            PlayerEvents.handleDoubleJump((Player)player);
        }
        if (!level.isClientSide) {
            PlayerEvents.tickEntitySwappers(entity);
        }
    }

    protected static void checkNearDeathExperience(ServerPlayer player) {
        float health = player.getHealth();
        UUID playerId = player.getUUID();
        if (health > 0.0f && health <= 6.0f && !NEAR_DEATH_ELIGIBLE.contains(playerId)) {
            NEAR_DEATH_ELIGIBLE.add(playerId);
        }
        if (health <= 0.0f && NEAR_DEATH_ELIGIBLE.contains(playerId)) {
            NEAR_DEATH_ELIGIBLE.remove(playerId);
        }
        if (NEAR_DEATH_ELIGIBLE.contains(playerId) && health >= player.getMaxHealth() && ResearchManager.isResearchComplete((Player)player, ResearchEntries.FIRST_STEPS)) {
            if (!ResearchManager.isResearchComplete((Player)player, ResearchEntries.NEAR_DEATH_EXPERIENCE)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.NEAR_DEATH_EXPERIENCE);
            }
            NEAR_DEATH_ELIGIBLE.remove(playerId);
        }
    }

    @VisibleForTesting
    public static void applyAttunementBuffs(ServerPlayer player) {
        if (AttunementManager.meetsThreshold((Player)player, Sources.SEA, AttunementThreshold.GREATER)) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 610, 0, true, false, true));
        }
        if (AttunementManager.meetsThreshold((Player)player, Sources.MOON, AttunementThreshold.GREATER)) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 610, 0, true, false, true));
        }
        AttributeInstance stepHeightAttribute = player.getAttribute(Attributes.STEP_HEIGHT);
        stepHeightAttribute.removeModifier(STEP_MODIFIER_EARTH.id());
        if (!player.isShiftKeyDown() && AttunementManager.meetsThreshold((Player)player, Sources.EARTH, AttunementThreshold.GREATER)) {
            stepHeightAttribute.addTransientModifier(STEP_MODIFIER_EARTH);
        }
    }

    protected static void refreshWeakenedSoul(ServerPlayer player) {
        Services.CAPABILITIES.cooldowns((Player)player).ifPresent(cooldowns -> {
            long remaining = cooldowns.getRemainingCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE);
            if (remaining > 0L && !player.hasEffect(EffectsPM.WEAKENED_SOUL.getHolder())) {
                player.addEffect(new MobEffectInstance(EffectsPM.WEAKENED_SOUL.getHolder(), Mth.ceil((float)((float)remaining / 50.0f)), 0, true, false, true));
            }
        });
    }

    protected static void checkEnvironmentalResearch(ServerPlayer player) {
        Services.CAPABILITIES.knowledge((Player)player).ifPresent(knowledge -> {
            Level level = player.level();
            if (!ResearchManager.isResearchStarted((Player)player, ResearchEntries.FIRST_STEPS)) {
                return;
            }
            Holder biomeHolder = level.getBiome(player.blockPosition());
            boolean inOverworld = level.dimension().equals(Level.OVERWORLD);
            if (!ResearchManager.isResearchStarted((Player)player, ResearchEntries.DISCOVER_INFERNAL) && biomeHolder.is(BiomeTags.IS_NETHER)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.DISCOVER_INFERNAL);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.discover_source.infernal").withStyle(ChatFormatting.GREEN), false);
            }
            if (!ResearchManager.isResearchStarted((Player)player, ResearchEntries.DISCOVER_VOID) && biomeHolder.is(BiomeTags.IS_END)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.DISCOVER_VOID);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.discover_source.void").withStyle(ChatFormatting.GREEN), false);
            }
            if (SOURCE_EARTH_START.isKnownBy((Player)player) && !SOURCE_EARTH_END.isKnownBy((Player)player) && player.position().y < -16.0 && inOverworld && !ResearchManager.isResearchStarted((Player)player, ResearchEntries.ENV_EARTH)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.ENV_EARTH);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.env_earth").withStyle(ChatFormatting.GREEN), false);
            }
            if (SOURCE_SEA_START.isKnownBy((Player)player) && !SOURCE_SEA_END.isKnownBy((Player)player) && biomeHolder.is(BiomeTags.IS_OCEAN) && !ResearchManager.isResearchStarted((Player)player, ResearchEntries.ENV_SEA)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.ENV_SEA);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.env_sea").withStyle(ChatFormatting.GREEN), false);
            }
            if (SOURCE_SKY_START.isKnownBy((Player)player) && !SOURCE_SKY_END.isKnownBy((Player)player) && player.position().y > 128.0 && inOverworld && !ResearchManager.isResearchStarted((Player)player, ResearchEntries.ENV_SKY)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.ENV_SKY);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.env_sky").withStyle(ChatFormatting.GREEN), false);
            }
            if (SOURCE_SUN_START.isKnownBy((Player)player) && !SOURCE_SUN_END.isKnownBy((Player)player) && (biomeHolder.is(Biomes.DESERT) || biomeHolder.is(BiomeTags.IS_BADLANDS)) && TimePhase.getSunPhase((LevelAccessor)level) == TimePhase.FULL && !ResearchManager.isResearchStarted((Player)player, ResearchEntries.ENV_SUN)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.ENV_SUN);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.env_sun").withStyle(ChatFormatting.GREEN), false);
            }
            if (SOURCE_MOON_START.isKnownBy((Player)player) && !SOURCE_MOON_END.isKnownBy((Player)player) && biomeHolder.is(BiomeTags.IS_FOREST) && TimePhase.getMoonPhase((LevelAccessor)level) == TimePhase.FULL && !ResearchManager.isResearchStarted((Player)player, ResearchEntries.ENV_MOON)) {
                ResearchManager.completeResearch((Player)player, ResearchEntries.ENV_MOON);
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.env_moon").withStyle(ChatFormatting.GREEN), false);
            }
        });
    }

    @VisibleForTesting
    public static void handlePhotosynthesis(ServerPlayer player) {
        Level level = player.level();
        if (AttunementManager.meetsThreshold((Player)player, Sources.SUN, AttunementThreshold.LESSER) && level.isDay() && player.getLightLevelDependentMagicValue() > 0.5f && level.canSeeSky(player.blockPosition())) {
            player.getFoodData().eat(1, 0.3f);
        }
    }

    @VisibleForTesting
    public static void handleLightDrop(ServerPlayer player, RandomSource randomSource) {
        BlockPos pos = player.blockPosition();
        Level world = player.level();
        if (randomSource.nextDouble() < 0.1 && AttunementManager.meetsThreshold((Player)player, Sources.SUN, AttunementThreshold.GREATER) && !player.isShiftKeyDown() && world.isEmptyBlock(pos) && !world.getBlockState(pos).is((Block)BlocksPM.GLOW_FIELD.get()) && world.getBrightness(LightLayer.BLOCK, pos) < 11) {
            world.setBlock(pos, (BlockState)BlocksPM.GLOW_FIELD.get().defaultBlockState().setValue((Property)GlowFieldBlock.FADING, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    protected static void handleDoubleJump(Player player) {
        Minecraft mc = Minecraft.getInstance();
        Level level = player.level();
        boolean jumpPressed = mc.options.keyJump.consumeClick();
        if (!(!jumpPressed && player.onGround() || DOUBLE_JUMP_ALLOWED.containsKey(player.getUUID()))) {
            DOUBLE_JUMP_ALLOWED.put(player.getUUID(), Boolean.TRUE);
        } else if (jumpPressed && !player.onGround() && !player.isInWater() && DOUBLE_JUMP_ALLOWED.getOrDefault(player.getUUID(), Boolean.FALSE).booleanValue() && AttunementManager.meetsThreshold(player, Sources.SKY, AttunementThreshold.GREATER)) {
            level.playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 0.1f, 1.0f + 0.05f * (float)level.random.nextGaussian(), false);
            DOUBLE_JUMP_ALLOWED.put(player.getUUID(), Boolean.FALSE);
            Vec3 oldMotion = player.getDeltaMovement();
            double motionX = oldMotion.x;
            double motionY = 0.75;
            double motionZ = oldMotion.z;
            if (player.hasEffect(MobEffects.JUMP)) {
                motionY += 0.1 * (double)(1 + player.getEffect(MobEffects.JUMP).getAmplifier());
            }
            if (player.isSprinting()) {
                float yawRadians = player.getYRot() * ((float)Math.PI / 180);
                motionX -= 0.2 * (double)Mth.sin((float)yawRadians);
                motionZ += 0.2 * (double)Mth.cos((float)yawRadians);
            }
            player.setDeltaMovement(motionX, motionY, motionZ);
            player.fallDistance = 0.0f;
            PacketHandler.sendToServer(new ResetFallDistancePacket());
            Services.EVENTS.fireLivingJumpEvent((LivingEntity)player);
        }
        if (player.onGround() && DOUBLE_JUMP_ALLOWED.containsKey(player.getUUID())) {
            DOUBLE_JUMP_ALLOWED.remove(player.getUUID());
        }
    }

    protected static void handleRegrowth(Player player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ItemStack stack : player.getAllSlots()) {
                ServerPlayer serverPlayer;
                if (!stack.isDamaged() || !EnchantmentHelperPM.hasRegrowth(stack, (HolderLookup.Provider)player.level().registryAccess())) continue;
                stack.hurtAndBreak(-1, serverLevel, player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null, item -> {});
            }
        }
    }

    protected static void handleWardRegeneration(ServerPlayer player) {
        Services.CAPABILITIES.ward((Player)player).ifPresent(wardCap -> {
            if (wardCap.isRegenerating()) {
                for (EquipmentSlot slot : wardCap.getApplicableSlots()) {
                    ManaStorage manaCap;
                    ItemStack slotStack = player.getItemBySlot(slot);
                    if (slotStack.isEmpty() || (manaCap = (ManaStorage)slotStack.get(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) == null || manaCap.getManaStored(Sources.EARTH) < 500) continue;
                    manaCap.extractMana(Sources.EARTH, 500, false);
                    slotStack.set(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)manaCap);
                    wardCap.incrementCurrentWard();
                    wardCap.sync(player);
                    player.connection.send((Packet)new ClientboundSetEquipmentPacket(player.getId(), List.of(Pair.of((Object)slot, (Object)slotStack.copy()))));
                    break;
                }
            }
        });
    }

    protected static void tickEntitySwappers(Entity entity) {
        Queue<EntitySwapper> swapperQueue = EntitySwapper.getSwapperQueue(entity);
        if (swapperQueue != null) {
            LinkedBlockingQueue<EntitySwapper> newQueue = new LinkedBlockingQueue<EntitySwapper>();
            while (!entity.isRemoved() && !swapperQueue.isEmpty()) {
                EntitySwapper swapper = swapperQueue.poll();
                if (swapper == null) continue;
                if (swapper.isReady()) {
                    swapper.execute(entity);
                    continue;
                }
                swapper.decrementDelay();
                newQueue.offer(swapper);
            }
            EntitySwapper.setSwapperQueue(entity, newQueue);
        }
    }

    public static void playerJoinEvent(Entity entity, Level level) {
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerEvents.doScheduledSyncs(player, true);
            ArcaneRecipeBookManager.syncRecipesWithResearch(player);
        }
    }

    protected static void doScheduledSyncs(ServerPlayer player, boolean immediate) {
        if (immediate || ResearchManager.isSyncScheduled((Player)player)) {
            Services.CAPABILITIES.knowledge((Player)player).ifPresent(knowledge -> knowledge.sync(player));
        }
        if (immediate || StatsManager.isSyncScheduled((Player)player)) {
            Services.CAPABILITIES.stats((Player)player).ifPresent(stats -> stats.sync(player));
        }
        if (immediate || AttunementManager.isSyncScheduled((Player)player)) {
            Services.CAPABILITIES.attunements((Player)player).ifPresent(attunements -> attunements.sync(player));
        }
        if (immediate || CompanionManager.isSyncScheduled((Player)player)) {
            Services.CAPABILITIES.companions((Player)player).ifPresent(companions -> companions.sync(player));
        }
        if (immediate || ArcaneRecipeBookManager.isSyncScheduled((Player)player)) {
            Services.CAPABILITIES.arcaneRecipeBook((Player)player).ifPresent(recipeBook -> recipeBook.sync(player));
        }
        if (immediate || LinguisticsManager.isSyncScheduled((Player)player)) {
            Services.CAPABILITIES.linguistics((Player)player).ifPresent(linguistics -> linguistics.sync(player));
        }
        if (immediate) {
            Services.CAPABILITIES.cooldowns((Player)player).ifPresent(cooldowns -> cooldowns.sync(player));
            Services.CAPABILITIES.ward((Player)player).ifPresent(wardCap -> wardCap.sync(player));
        }
    }

    public static void playerCloneEvent(Player oldPlayer, Player newPlayer, boolean wasFromDeath) {
        RegistryAccess registryAccess = newPlayer.registryAccess();
        try {
            Object nbtKnowledge = Services.CAPABILITIES.knowledge(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.knowledge(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtKnowledge);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} knowledge", (Object)oldPlayer.getName().getString());
        }
        try {
            CompoundTag nbtCooldowns = (CompoundTag)Services.CAPABILITIES.cooldowns(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.cooldowns(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtCooldowns);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} cooldowns", (Object)oldPlayer.getName().getString());
        }
        try {
            CompoundTag nbtStats = (CompoundTag)Services.CAPABILITIES.stats(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.stats(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtStats);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} stats", (Object)oldPlayer.getName().getString());
        }
        try {
            CompoundTag nbtAttunements = (CompoundTag)Services.CAPABILITIES.attunements(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.attunements(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtAttunements);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} attunements", (Object)oldPlayer.getName().getString());
        }
        try {
            CompoundTag nbtCompanions = (CompoundTag)Services.CAPABILITIES.companions(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.companions(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtCompanions);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} companions", (Object)oldPlayer.getName().getString());
        }
        try {
            CompoundTag nbtRecipeBook = Services.CAPABILITIES.arcaneRecipeBook(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.arcaneRecipeBook(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtRecipeBook, newPlayer.level().getRecipeManager());
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} arcane recipe book", (Object)oldPlayer.getName().getString());
        }
        try {
            CompoundTag nbtWard = (CompoundTag)Services.CAPABILITIES.ward(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.ward(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtWard);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} ward", (Object)oldPlayer.getName().getString());
        }
        try {
            CompoundTag nbtLinguistics = (CompoundTag)Services.CAPABILITIES.linguistics(oldPlayer).orElseThrow(IllegalArgumentException::new).serializeNBT((HolderLookup.Provider)registryAccess);
            Services.CAPABILITIES.linguistics(newPlayer).orElseThrow(IllegalArgumentException::new).deserializeNBT((HolderLookup.Provider)registryAccess, nbtLinguistics);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} linguistics", (Object)oldPlayer.getName().getString());
        }
        if (wasFromDeath) {
            AttunementManager.refreshAttributeModifiers(newPlayer);
        }
    }

    public static void registerItemCrafted(Player player, ItemStack stack) {
        if (player != null && !player.level().isClientSide) {
            if (ResearchManager.getAllCraftingReferences().contains(ItemUtils.getHashCode(stack))) {
                ResearchManager.completeResearch(player, new StackCraftedKey(stack));
            }
            stack.getTags().filter(Objects::nonNull).forEach(tagKey -> {
                int tagHash = tagKey.hashCode();
                if (ResearchManager.getAllCraftingReferences().contains(tagHash)) {
                    ResearchManager.completeResearch(player, new TagCraftedKey((TagKey<Item>)tagKey));
                }
            });
        }
    }

    public static void onWakeUp(Player player) {
        if (player != null && !player.level().isClientSide) {
            NonNullList<ItemStack> foundTalismans;
            if (ResearchManager.isResearchComplete(player, ResearchEntries.FOUND_SHRINE) && !ResearchManager.isResearchComplete(player, ResearchEntries.GOT_DREAM)) {
                PlayerEvents.grantDreamJournal(player);
            }
            if (!(foundTalismans = InventoryUtils.find(player, ItemsPM.DREAM_VISION_TALISMAN.get().getDefaultInstance())).isEmpty()) {
                boolean success = false;
                for (ItemStack talismanStack : foundTalismans) {
                    DreamVisionTalismanItem talisman;
                    Item item = talismanStack.getItem();
                    if (!(item instanceof DreamVisionTalismanItem) || !(talisman = (DreamVisionTalismanItem)item).isActive(talismanStack) || !talisman.isReadyToDrain(talismanStack)) continue;
                    success = success || talisman.doDrain(talismanStack, player);
                }
                if (success) {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.dream_vision_talisman.drained").withStyle(ChatFormatting.GREEN), false);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PacketHandler.sendToPlayer(new PlayClientSoundPacket(SoundsPM.WRITING.get(), 1.0f, 1.0f + (float)player.getRandom().nextGaussian() * 0.05f), serverPlayer);
                    }
                }
            }
        }
    }

    protected static void grantDreamJournal(Player player) {
        ResearchManager.completeResearch(player, ResearchEntries.GOT_DREAM);
        ItemStack journal = StaticBookItem.builder(ItemsPM.STATIC_BOOK, (HolderLookup.Provider)player.registryAccess()).book(BooksPM.DREAM_JOURNAL).language(BookLanguagesPM.DEFAULT).author(player.getName().getString()).build();
        if (!player.addItem(journal)) {
            player.drop(journal, false);
        }
        player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.got_dream").withStyle(ChatFormatting.GREEN));
    }

    public static void onJump(LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && AttunementManager.meetsThreshold(player = (Player)livingEntity, Sources.SKY, AttunementThreshold.GREATER)) {
            Vec3 motion = player.getDeltaMovement();
            motion = motion.add(0.0, 0.275, 0.0);
            player.setDeltaMovement(motion);
        }
    }

    public static void onPlayerInteractLeftClickBlock(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        LAST_BLOCK_LEFT_CLICK.put(player.getUUID(), new InteractionRecord(player, hand, pos, face));
    }

    public static void onPickupExperience(Player player, ExperienceOrb orb) {
        NonNullList<ItemStack> foundTalismans;
        Level level = player.level();
        if (player != null && !level.isClientSide && !(foundTalismans = InventoryUtils.find(player, ItemsPM.DREAM_VISION_TALISMAN.get().getDefaultInstance())).isEmpty()) {
            int xpValue = orb.getValue();
            for (ItemStack foundStack : foundTalismans) {
                DreamVisionTalismanItem talisman;
                Item item = foundStack.getItem();
                if (!(item instanceof DreamVisionTalismanItem) || !(talisman = (DreamVisionTalismanItem)item).isActive(foundStack) || (xpValue = talisman.addStoredExp(foundStack, xpValue)) > 0) continue;
                orb.value = 0;
                return;
            }
            orb.value = xpValue;
        }
    }

    public static void onUseHoe(Player player, UseOnContext context, Consumer<BlockState> stateUpdater) {
        ItemStack stack = context.getItemInHand();
        int enchantLevel = EnchantmentHelperPM.getEnchantmentLevel(stack, EnchantmentsPM.VERDANT, (HolderLookup.Provider)context.getPlayer().registryAccess());
        if (enchantLevel > 0) {
            BonemealableBlock mealBlock;
            Block block;
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            BlockState state = level.getBlockState(pos);
            if (!player.isShiftKeyDown() && (block = state.getBlock()) instanceof BonemealableBlock && (mealBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, state)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (mealBlock.isBonemealSuccess(level, level.random, pos, state)) {
                        mealBlock.performBonemeal(serverLevel, level.random, pos, state);
                    }
                    int baseDamage = 8;
                    int damage = 8 >> enchantLevel - 1;
                    if (damage > 0) {
                        stack.hurtAndBreak(damage, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                    }
                    stateUpdater.accept(level.getBlockState(pos));
                }
                if (!level.isClientSide) {
                    level.levelEvent(1505, pos, 0);
                }
            }
        }
    }

    public static void onEntityInteract(Player player, InteractionHand hand, Entity target) {
        ItemStack stack = player.getItemInHand(hand);
        Level level = target.level();
        if (!level.isClientSide && target.getType() == EntityType.WITCH && stack.getItem() instanceof NameTagItem && stack.getHoverName().getString().equals("Corspilla")) {
            CompoundTag originalData = target.saveWithoutId(new CompoundTag());
            EntitySwapper.enqueue(target, new EntitySwapper(EntityTypesPM.FRIENDLY_WITCH.get(), originalData, Optional.empty(), 0));
            List<Player> nearby = EntityUtils.getEntitiesInRange(level, target.position(), null, Player.class, 32.0);
            for (Player nearbyPlayer : nearby) {
                nearbyPlayer.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.friendly_witch.spawn", (Object[])new Object[]{"Corspilla"}));
            }
        }
    }
}

