/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.events.ModLifecycleEvents;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

@EventBusSubscriber(modid="primalmagick", bus=EventBusSubscriber.Bus.MOD)
public class ModLifecycleEventListeners {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        ModLifecycleEvents.commonSetup(arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0));
        event.enqueueWork(ModLifecycleEventListeners::registerFlowerPotPlants);
    }

    private static void registerFlowerPotPlants() {
        Block block = Blocks.FLOWER_POT;
        if (block instanceof FlowerPotBlock) {
            FlowerPotBlock emptyPotBlock = (FlowerPotBlock)block;
            ModLifecycleEventListeners.registerPottedPlant(emptyPotBlock, BlocksPM.POTTED_SUNWOOD_SAPLING);
            ModLifecycleEventListeners.registerPottedPlant(emptyPotBlock, BlocksPM.POTTED_MOONWOOD_SAPLING);
            ModLifecycleEventListeners.registerPottedPlant(emptyPotBlock, BlocksPM.POTTED_HALLOWOOD_SAPLING);
        }
    }

    private static void registerPottedPlant(FlowerPotBlock emptyPotBlock, Supplier<FlowerPotBlock> flowerSupplier) {
        emptyPotBlock.addPlant(BuiltInRegistries.BLOCK.getKey((Object)flowerSupplier.get().getPotted()), flowerSupplier);
    }
}

