/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenEnchantedBookScreenPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Comparator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class ItemEvents {
    public static InteractionResult onItemRightClick(ItemStack stack, Player player, Level level) {
        InteractionResult result = InteractionResult.PASS;
        if (stack.is(Items.ENCHANTED_BOOK)) {
            result = ItemEvents.handleEnchantedBookRightClick(stack, player, level);
        }
        return result;
    }

    private static InteractionResult handleEnchantedBookRightClick(ItemStack stack, Player player, Level level) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().stream().min(Comparator.comparing(Object2IntMap.Entry::getIntValue)).ifPresent(entry -> PacketHandler.sendToPlayer(new OpenEnchantedBookScreenPacket((Holder<Enchantment>)((Holder)entry.getKey()), (HolderLookup.Provider)player.registryAccess()), serverPlayer));
        }
        return InteractionResult.SUCCESS;
    }
}

