/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.armor.WardingModuleItem;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityEvents {
    public static boolean onEnderTeleport(LivingEntity entity, Vec3 target) {
        if (entity.hasEffect(EffectsPM.ENDERLOCK.getHolder())) {
            return true;
        }
        return EntityEvents.checkEnderward(entity, target);
    }

    private static boolean checkEnderward(LivingEntity entity, Vec3 target) {
        AABB searchAABB = new AABB(BlockPos.containing((Position)target)).inflate(16.0).setMinY((double)entity.level().getMinBuildHeight()).setMaxY((double)entity.level().getMaxBuildHeight());
        if (BlockPos.betweenClosedStream((AABB)searchAABB).anyMatch(pos -> entity.level().getBlockState(pos).is((Block)BlocksPM.ENDERWARD.get()))) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.enderward.block").withStyle(ChatFormatting.RED), true);
            }
            return true;
        }
        return false;
    }

    public static void onEnderTeleportLowest(Player player, Vec3 target) {
        StatsManager.incrementValue(player, StatsPM.DISTANCE_TELEPORTED_CM, (int)(100.0 * player.position().distanceTo(target)));
    }

    public static void onAnimalTameLowest(Player player, Animal animal) {
        if (animal instanceof Wolf && ResearchManager.isResearchComplete(player, ResearchEntries.FIRST_STEPS) && !ResearchManager.isResearchComplete(player, ResearchEntries.FURRY_FRIEND)) {
            ResearchManager.completeResearch(player, ResearchEntries.FURRY_FRIEND);
        }
    }

    public static void onBabyEntitySpawnLowest(Player player) {
        if (ResearchManager.isResearchComplete(player, ResearchEntries.FIRST_STEPS) && !ResearchManager.isResearchComplete(player, ResearchEntries.BREED_ANIMAL)) {
            ResearchManager.completeResearch(player, ResearchEntries.BREED_ANIMAL);
        }
    }

    public static void onLivingEntityUseItemTick(LivingEntity entity, ItemStack stack, int currentDuration) {
        int maxDuration = stack.getUseDuration(entity);
        int delta = maxDuration - currentDuration;
        int enchantLevel = EnchantmentHelperPM.getEnchantmentLevel(stack, EnchantmentsPM.BULWARK, (HolderLookup.Provider)entity.registryAccess());
        if (stack.getItem() instanceof ShieldItem && delta > 0 && delta % 5 == 0 && enchantLevel > 0) {
            MobEffectInstance effectInstance = entity.getEffect(MobEffects.DAMAGE_RESISTANCE);
            int amplifier = effectInstance == null ? 0 : Mth.clamp((int)(1 + effectInstance.getAmplifier()), (int)0, (int)(enchantLevel - 1));
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 10, amplifier));
        }
    }

    public static void onLivingEquipmentChange(LivingEntity livingEntity, ItemStack fromStack, ItemStack toStack) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (WardingModuleItem.hasWardAttached(fromStack) || WardingModuleItem.hasWardAttached(toStack)) {
                Services.CAPABILITIES.ward((Player)serverPlayer).ifPresent(playerWard -> {
                    int newMax = playerWard.getApplicableSlots().stream().map(arg_0 -> ((ServerPlayer)serverPlayer).getItemBySlot(arg_0)).filter(WardingModuleItem::hasWardAttached).mapToInt(stack -> 1 + WardingModuleItem.getAttachedWardLevel(stack)).sum();
                    playerWard.setMaxWard(newMax);
                    playerWard.sync(serverPlayer);
                });
            }
        }
    }
}

