/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.damagesource.DamageSourcesPM;
import com.verdantartifice.primalmagick.common.damagesource.DamageTypesPM;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellBoltPacket;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.util.EntitySelectorsPM;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.VisibleForTesting;

public class CombatEvents {
    public static boolean onAttack(LivingEntity targetEntity, DamageSource damageSource, float amount) {
        Entity targetLevel;
        if (targetEntity instanceof Player) {
            float newDamage;
            Player target = (Player)targetEntity;
            if (damageSource.is(DamageTypeTags.IS_FIRE) && AttunementManager.meetsThreshold(target, Sources.INFERNAL, AttunementThreshold.GREATER)) {
                return true;
            }
            if (damageSource == target.damageSources().fall() && AttunementManager.meetsThreshold(target, Sources.SKY, AttunementThreshold.LESSER) && (newDamage = Math.max(0.0f, amount / 3.0f - 2.0f)) < 1.0f) {
                return true;
            }
            targetLevel = target.level();
            CombatEvents.grantInvisibilityOnHurt(target, (Level)targetLevel, targetLevel.random);
        }
        if ((targetLevel = damageSource.getEntity()) instanceof Player) {
            Player attacker = (Player)targetLevel;
            Level attackerLevel = attacker.level();
            if (!damageSource.is(DamageTypesPM.HELLISH_CHAIN) && amount > 0.0f && attackerLevel instanceof ServerLevel) {
                List<LivingEntity> targets;
                ServerLevel serverLevel = (ServerLevel)attackerLevel;
                if (AttunementManager.meetsThreshold(attacker, Sources.INFERNAL, AttunementThreshold.LESSER) && !(targets = EntityUtils.getEntitiesInRangeSorted(attackerLevel, targetEntity.position(), Arrays.asList(targetEntity, attacker), LivingEntity.class, 4.0, EntitySelectorsPM.validHellishChainTarget(attacker))).isEmpty()) {
                    LivingEntity target = targets.getFirst();
                    target.hurt(DamageSourcesPM.hellishChain(attackerLevel.registryAccess(), (LivingEntity)attacker), amount / 2.0f);
                    PacketHandler.sendToAllAround(new SpellBoltPacket(targetEntity.getEyePosition(1.0f), target.getEyePosition(1.0f), Sources.INFERNAL.getColor()), serverLevel, targetEntity.blockPosition(), 64.0);
                    attackerLevel.playSound(null, targetEntity.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 1.0f, 1.0f + (float)(attackerLevel.random.nextGaussian() * 0.05));
                }
            }
        }
        return false;
    }

    @VisibleForTesting
    public static void grantInvisibilityOnHurt(Player player, Level level, RandomSource random) {
        if (random.nextDouble() < 0.5 && !player.hasEffect(MobEffects.INVISIBILITY) && AttunementManager.meetsThreshold(player, Sources.MOON, AttunementThreshold.LESSER)) {
            level.playSound(player, player.blockPosition(), SoundsPM.SHIMMER.get(), SoundSource.PLAYERS, 1.0f, 1.0f + 0.05f * (float)random.nextGaussian());
            player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 200));
        }
    }

    public static void onEntityHurt(LivingEntity targetEntity, DamageSource damageSource, Supplier<Float> damageGetter, Consumer<Float> damageSetter) {
        Entity newDamage2;
        if (targetEntity instanceof Player) {
            float newDamage2;
            Player target = (Player)targetEntity;
            if (ResearchManager.isResearchComplete(target, ResearchEntries.FIRST_STEPS)) {
                if (damageSource == target.damageSources().drown() && !ResearchManager.isResearchComplete(target, ResearchEntries.DROWN_A_LITTLE)) {
                    ResearchManager.completeResearch(target, ResearchEntries.DROWN_A_LITTLE);
                }
                if (damageSource == target.damageSources().lava() && !ResearchManager.isResearchComplete(target, ResearchEntries.FEEL_THE_BURN)) {
                    ResearchManager.completeResearch(target, ResearchEntries.FEEL_THE_BURN);
                }
            }
            if (damageSource == target.damageSources().fall() && AttunementManager.meetsThreshold(target, Sources.SKY, AttunementThreshold.LESSER) && (newDamage2 = Math.max(0.0f, damageGetter.get().floatValue() / 3.0f - 2.0f)) < damageGetter.get().floatValue()) {
                damageSetter.accept(Float.valueOf(newDamage2));
            }
            if (!damageSource.is(DamageTypeTags.BYPASSES_EFFECTS) && AttunementManager.meetsThreshold(target, Sources.VOID, AttunementThreshold.LESSER)) {
                damageSetter.accept(Float.valueOf(0.9f * damageGetter.get().floatValue()));
            }
            if (!damageSource.is(DamageTypeTags.BYPASSES_EFFECTS) && damageGetter.get().floatValue() > 0.0f) {
                Services.CAPABILITIES.ward(target).ifPresent(wardCap -> {
                    if (((Float)damageGetter.get()).floatValue() >= wardCap.getCurrentWard()) {
                        damageSetter.accept(Float.valueOf(((Float)damageGetter.get()).floatValue() - wardCap.getCurrentWard()));
                        wardCap.setCurrentWard(0.0f);
                    } else {
                        wardCap.decrementCurrentWard(((Float)damageGetter.get()).floatValue());
                        damageSetter.accept(Float.valueOf(0.0f));
                    }
                    wardCap.pauseRegeneration();
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverTarget = (ServerPlayer)target;
                        wardCap.sync(serverTarget);
                    }
                });
            }
        }
        if ((newDamage2 = damageSource.getEntity()) instanceof Player) {
            Player attacker = (Player)newDamage2;
            Level level = attacker.level();
            if (!damageSource.is(DamageTypeTags.BYPASSES_EFFECTS) && AttunementManager.meetsThreshold(attacker, Sources.VOID, AttunementThreshold.GREATER)) {
                damageSetter.accept(Float.valueOf(1.25f * damageGetter.get().floatValue()));
            }
            if (targetEntity.isInvertedHealAndHarm() && AttunementManager.meetsThreshold(attacker, Sources.HALLOWED, AttunementThreshold.LESSER)) {
                damageSetter.accept(Float.valueOf(2.0f * damageGetter.get().floatValue()));
            }
            if (damageGetter.get().floatValue() >= 1.0f && AttunementManager.meetsThreshold(attacker, Sources.BLOOD, AttunementThreshold.LESSER)) {
                targetEntity.addEffect(new MobEffectInstance(EffectsPM.BLEEDING.getHolder(), 200));
            }
            if (level.random.nextFloat() < damageGetter.get().floatValue() / 12.0f && AttunementManager.meetsThreshold(attacker, Sources.BLOOD, AttunementThreshold.GREATER)) {
                attacker.heal(1.0f);
            }
        }
    }

    public static void onEntityHurtLowest(LivingEntity targetEntity, DamageSource damageSource, float amount) {
        if (targetEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)targetEntity;
            CriteriaTriggersPM.ENTITY_HURT_PLAYER_EXT.get().trigger(serverPlayer, damageSource, amount);
        }
    }

    public static boolean onDeath(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = player.level();
            if (AttunementManager.meetsThreshold(player, Sources.HALLOWED, AttunementThreshold.GREATER) && Services.CAPABILITIES.cooldowns(player).map(c -> !c.isOnCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE)).orElse(false).booleanValue()) {
                player.setHealth(1.0f);
                player.removeAllEffects();
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                player.addEffect(new MobEffectInstance(EffectsPM.WEAKENED_SOUL.getHolder(), 6000, 0, true, false, true));
                Services.CAPABILITIES.cooldowns(player).ifPresent(c -> c.setCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE, 6000));
                level.playSound(null, player.blockPosition(), SoundsPM.ANGELS.get(), SoundSource.PLAYERS, 1.0f, 1.0f + 0.05f * (float)level.random.nextGaussian());
                return true;
            }
        }
        if (entity.hasEffect(EffectsPM.DRAIN_SOUL.getHolder())) {
            float gems = entity.getType().getCategory().isFriendly() ? Mth.sqrt((float)entity.getMaxHealth()) / 20.0f : entity.getMaxHealth() / 20.0f;
            int wholeGems = Mth.floor((float)gems);
            int slivers = Mth.floor((float)(Mth.frac((float)gems) * 10.0f));
            Containers.dropItemStack((Level)entity.getCommandSenderWorld(), (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (ItemStack)new ItemStack((ItemLike)ItemsPM.SOUL_GEM.get(), wholeGems));
            Containers.dropItemStack((Level)entity.getCommandSenderWorld(), (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (ItemStack)new ItemStack((ItemLike)ItemsPM.SOUL_GEM_SLIVER.get(), slivers));
        }
        return false;
    }

    public static void onArrowImpact(Projectile projectile, HitResult hitResult) {
        Entity targetEntity;
        LivingEntity livingShooter;
        Entity shooter = projectile.getOwner();
        if (shooter instanceof LivingEntity && EnchantmentHelperPM.hasEnderport(livingShooter = (LivingEntity)shooter)) {
            EntityUtils.teleportEntity(livingShooter, projectile.level(), hitResult.getLocation());
        }
        if (hitResult.getType() == HitResult.Type.ENTITY && (targetEntity = ((EntityHitResult)hitResult).getEntity()) instanceof LivingEntity) {
            MobEffectInstance soulpiercedInstance;
            LivingEntity livingShooter2;
            int soulpiercingLevel;
            LivingEntity target = (LivingEntity)targetEntity;
            if (shooter instanceof LivingEntity && (soulpiercingLevel = EnchantmentHelperPM.getEnchantmentLevel((livingShooter2 = (LivingEntity)shooter).getMainHandItem(), EnchantmentsPM.SOULPIERCING, (HolderLookup.Provider)livingShooter2.registryAccess())) > 0 && target.canBeAffected(soulpiercedInstance = new MobEffectInstance(EffectsPM.SOULPIERCED.getHolder(), 12000, 0, false, false)) && !target.hasEffect(soulpiercedInstance.getEffect())) {
                Containers.dropItemStack((Level)target.level(), (double)target.getX(), (double)target.getY(), (double)target.getZ(), (ItemStack)new ItemStack((ItemLike)ItemsPM.SOUL_GEM_SLIVER.get(), soulpiercingLevel));
                target.addEffect(soulpiercedInstance);
            }
        }
    }

    public static boolean isPotionApplicable(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        return !effectInstance.getEffect().is(EffectsPM.BLEEDING.getHolder()) || !livingEntity.isInvertedHealAndHarm();
    }
}

