/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.books.BookType;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.events.PlayerEvents;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.misc.BlockBreaker;
import com.verdantartifice.primalmagick.common.misc.InteractionRecord;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenEnchantedBookScreenPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenGrimoireScreenPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenStaticBookScreenPacket;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEvents {
    public static void onBlockBreak(Player player, Level level, BlockPos pos, BlockState state) {
        if (!(level == null || level.isClientSide || player.isSecondaryUseActive() || BlockBreaker.hasBreakerQueued(level, pos))) {
            BlockEvents.triggerReverberation(level, pos, state, player, player.getMainHandItem());
            BlockEvents.triggerDisintegration(level, pos, state, player, player.getMainHandItem());
        }
    }

    private static void triggerReverberation(Level world, BlockPos pos, BlockState state, Player player, ItemStack tool) {
        Direction dir;
        int enchLevel = EnchantmentHelperPM.getEnchantmentLevel(tool, EnchantmentsPM.REVERBERATION, (HolderLookup.Provider)world.registryAccess());
        if (enchLevel <= 0) {
            return;
        }
        InteractionRecord interact = PlayerEvents.LAST_BLOCK_LEFT_CLICK.get(player.getUUID());
        if (interact == null) {
            Vec3 endPos;
            Vec3 startPos = player.getEyePosition(1.0f);
            BlockHitResult rayTraceResult = world.clip(new ClipContext(startPos, endPos = startPos.add(player.getViewVector(1.0f).scale(player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (rayTraceResult.getType() == HitResult.Type.MISS) {
                return;
            }
            dir = rayTraceResult.getDirection();
        } else {
            dir = interact.getFace();
        }
        float durability = (float)Math.sqrt(100.0f * state.getDestroySpeed((BlockGetter)world, pos));
        int xLimit = enchLevel * (dir.getStepX() == 0 ? 1 : 0);
        int yLimit = enchLevel * (dir.getStepY() == 0 ? 1 : 0);
        int zLimit = enchLevel * (dir.getStepZ() == 0 ? 1 : 0);
        for (int dx = -xLimit; dx <= xLimit; ++dx) {
            for (int dy = -yLimit; dy <= yLimit; ++dy) {
                for (int dz = -zLimit; dz <= zLimit; ++dz) {
                    BlockPos targetPos = new BlockPos(pos.getX() + dx, pos.getY() + dy, pos.getZ() + dz);
                    if (targetPos.equals((Object)pos)) continue;
                    BlockState targetState = world.getBlockState(targetPos);
                    float targetDurability = (float)Math.sqrt(100.0f * targetState.getDestroySpeed((BlockGetter)world, pos));
                    float newDurability = Math.max(0.0f, targetDurability - durability);
                    BlockBreaker breaker = new BlockBreaker.Builder().target(targetPos, targetState).durability(newDurability, targetDurability).player(player).tool(tool).oneShot().skipEvent().build();
                    BlockBreaker.schedule(world, targetPos.distManhattan((Vec3i)pos), breaker);
                }
            }
        }
    }

    private static void triggerDisintegration(Level world, BlockPos pos, BlockState state, Player player, ItemStack tool) {
        int enchLevel = EnchantmentHelperPM.getEnchantmentLevel(tool, EnchantmentsPM.DISINTEGRATION, (HolderLookup.Provider)world.registryAccess());
        if (enchLevel <= 0) {
            return;
        }
        float durability = (float)Math.sqrt(100.0f * state.getDestroySpeed((BlockGetter)world, pos));
        int breakerCount = 10 * enchLevel - 1;
        HashSet<BlockPos> examinedPositions = new HashSet<BlockPos>();
        LinkedList<BlockPos> processingQueue = new LinkedList<BlockPos>();
        examinedPositions.add(pos);
        for (Direction dir : Direction.values()) {
            BlockPos setupPos = pos.relative(dir);
            examinedPositions.add(setupPos);
            processingQueue.offer(setupPos);
        }
        while (!processingQueue.isEmpty() && breakerCount > 0) {
            BlockPos curPos = (BlockPos)processingQueue.poll();
            BlockState curState = world.getBlockState(curPos);
            if (!curState.getBlock().equals(state.getBlock())) continue;
            --breakerCount;
            BlockBreaker breaker = new BlockBreaker.Builder().target(curPos, curState).durability(0.0f, durability).player(player).tool(tool).oneShot().skipEvent().build();
            BlockBreaker.schedule(world, curPos.distManhattan((Vec3i)pos), breaker);
            for (Direction dir : Direction.values()) {
                BlockPos nextPos = curPos.relative(dir);
                if (examinedPositions.contains(nextPos)) continue;
                examinedPositions.add(nextPos);
                processingQueue.offer(nextPos);
            }
        }
    }

    public static void onBlockBreakLowest(Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        if (state.getDestroySpeed((BlockGetter)level, pos) >= 2.0f && player.getMainHandItem().isEmpty()) {
            StatsManager.incrementValue(player, StatsPM.BLOCKS_BROKEN_BAREHANDED);
        }
    }

    public static InteractionResult onBlockRightClick(Player player, LevelAccessor level, BlockHitResult hitResult, InteractionHand hand) {
        BlockEntity blockEntity = level.getBlockEntity(hitResult.getBlockPos());
        if (blockEntity instanceof LecternBlockEntity) {
            LecternBlockEntity lecternEntity = (LecternBlockEntity)blockEntity;
            return BlockEvents.handleLecternRightClick(lecternEntity, player, hand);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult handleLecternRightClick(LecternBlockEntity lecternEntity, Player player, InteractionHand hand) {
        Level level = lecternEntity.getLevel();
        if (((Boolean)lecternEntity.getBlockState().getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            if (player.isSecondaryUseActive()) {
                ItemStack bookStack = lecternEntity.getBook();
                lecternEntity.setBook(ItemStack.EMPTY);
                LecternBlock.resetBookState((Entity)player, (Level)level, (BlockPos)lecternEntity.getBlockPos(), (BlockState)lecternEntity.getBlockState(), (boolean)false);
                if (!player.getInventory().add(bookStack)) {
                    player.drop(bookStack, false);
                }
                return InteractionResult.SUCCESS;
            }
            if (lecternEntity.getBook().is((Item)ItemsPM.GRIMOIRE.get())) {
                if (!level.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    StatsManager.incrementValue(player, StatsPM.GRIMOIRE_READ);
                    PacketHandler.sendToPlayer(new OpenGrimoireScreenPacket(), serverPlayer);
                }
                return InteractionResult.SUCCESS;
            }
            if (lecternEntity.getBook().is(ItemTagsPM.STATIC_BOOKS)) {
                if (!level.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketHandler.sendToPlayer(new OpenStaticBookScreenPacket(lecternEntity.getBook(), BookType.BOOK, (HolderLookup.Provider)player.registryAccess()), serverPlayer);
                }
                return InteractionResult.SUCCESS;
            }
            if (lecternEntity.getBook().is(Items.ENCHANTED_BOOK)) {
                if (!level.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)lecternEntity.getBook()).entrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue)).findFirst().ifPresent(entry -> PacketHandler.sendToPlayer(new OpenEnchantedBookScreenPacket((Holder<Enchantment>)((Holder)entry.getKey()), (HolderLookup.Provider)player.registryAccess()), serverPlayer));
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            ItemStack handStack = player.getItemInHand(hand);
            if (handStack.is(ItemTags.LECTERN_BOOKS) && LecternBlock.tryPlaceBook((LivingEntity)player, (Level)level, (BlockPos)lecternEntity.getBlockPos(), (BlockState)lecternEntity.getBlockState(), (ItemStack)handStack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

