/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.events.BlockEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="primalmagick")
public class BlockEventListeners {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level l;
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        Level level2 = level = levelAccessor instanceof Level ? (l = (Level)levelAccessor) : null;
        if (!event.isCanceled()) {
            BlockEvents.onBlockBreak(event.getPlayer(), level, event.getPos(), event.getState());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockBreakLowest(BlockEvent.BreakEvent event) {
        if (!event.isCanceled()) {
            BlockEvents.onBlockBreakLowest(event.getPlayer(), event.getLevel(), event.getPos(), event.getState());
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = BlockEvents.onBlockRightClick(event.getEntity(), (LevelAccessor)event.getLevel(), event.getHitVec(), event.getHand());
        if (result.consumesAction()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }
}

