/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.ai.sensing.SensorTypesPM;
import com.verdantartifice.primalmagick.common.entities.projectiles.AppleEntity;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkAi;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkArmPose;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreefolkEntity
extends AgeableMob
implements RangedAttackMob {
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final String DREADED_NAME = "Verdus";
    protected static final ImmutableList<SensorType<? extends Sensor<? super TreefolkEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.HURT_BY, SensorTypesPM.TREEFOLK_SPECIFIC_SENSOR.get(), SensorTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object[])new MemoryModuleType[]{MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.PATH, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.ADMIRING_ITEM, MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, MemoryModuleType.ADMIRING_DISABLED, MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, MemoryModuleType.CELEBRATE_LOCATION, MemoryModuleType.DANCING, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleTypesPM.NEARBY_ADULT_TREEFOLK.get(), MemoryModuleTypesPM.NEAREST_VISIBLE_ADULT_TREEFOLK.get(), MemoryModuleTypesPM.DANCED_RECENTLY.get(), MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get(), MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), MemoryModuleTypesPM.FERTILIZED_RECENTLY.get(), MemoryModuleTypesPM.TIME_TRYING_TO_REACH_FERTILIZE_BLOCK.get(), MemoryModuleTypesPM.DISABLE_WALK_TO_FERTILIZE_BLOCK.get(), MemoryModuleTypesPM.NEARBY_TREEFOLK.get(), MemoryModuleType.AVOID_TARGET});
    private static final EntityDataAccessor<Boolean> DATA_IS_DANCING = SynchedEntityData.defineId(TreefolkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public TreefolkEntity(EntityType<? extends TreefolkEntity> entityType, Level world) {
        super(entityType, world);
        this.setCanPickUpLoot(true);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder getAttributeModifiers() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 4.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    public static boolean canSpawnOn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return Mob.checkMobSpawnRules(typeIn, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_DANCING, (Object)false);
    }

    public boolean isAngry() {
        return this.isAggressive();
    }

    public boolean isAdult() {
        return !this.isBaby();
    }

    protected Brain.Provider<TreefolkEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> pDynamic) {
        return TreefolkAi.makeBrain(this, (Brain<TreefolkEntity>)this.brainProvider().makeBrain(pDynamic));
    }

    public Brain<TreefolkEntity> getBrain() {
        return super.getBrain();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundsPM.TREEFOLK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundsPM.TREEFOLK_DEATH.get();
    }

    protected void customServerAiStep() {
        Level level = this.level();
        level.getProfiler().push("treefolkBrain");
        this.getBrain().tick((ServerLevel)level, (LivingEntity)this);
        level.getProfiler().pop();
        TreefolkAi.updateActivity(this);
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (this.hasCustomName() && DREADED_NAME.equals(this.getCustomName().getString())) {
            this.igniteForSeconds(8.0f);
        }
    }

    public void setCustomName(Component name) {
        super.setCustomName(name);
        Level level = this.level();
        if (!level.isClientSide && DREADED_NAME.equals(name.getString())) {
            List<Player> nearby = EntityUtils.getEntitiesInRange(level, this.position(), null, Player.class, 6.0);
            for (Player player : nearby) {
                StatsManager.incrementValue(player, StatsPM.TREANTS_NAMED);
            }
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        Level level = this.level();
        AppleEntity missile = new AppleEntity(level, (LivingEntity)this);
        missile.setItem(new ItemStack((ItemLike)Items.APPLE));
        double d0 = target.getEyeY() - (double)1.1f;
        double d1 = target.getX() - this.getX();
        double d2 = d0 - missile.getY();
        double d3 = target.getZ() - this.getZ();
        float f = (float)Math.sqrt(d1 * d1 + d3 * d3) * 0.2f;
        missile.shoot(d1, d2 + (double)f, d3, 1.6f, 14 - level.getDifficulty().getId() * 4);
        this.playSound(SoundEvents.SNOWBALL_THROW, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        level.addFreshEntity((Entity)missile);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level level = this.level();
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Items.FLINT_AND_STEEL)) {
            level.playSound(player, this.getX(), this.getY(), this.getZ(), SoundEvents.FLINTANDSTEEL_USE, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!level.isClientSide) {
                this.igniteForSeconds(10.0f);
                this.setLastHurtByMob((LivingEntity)player);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!level.isClientSide) {
            return TreefolkAi.mobInteract(this, player, hand);
        }
        boolean flag = TreefolkAi.canAdmire(this, stack) && this.getArmPose() != TreefolkArmPose.ADMIRING_ITEM;
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean wantsToPickUp(ItemStack pStack) {
        return Services.EVENTS.canEntityGrief(this.level(), (Entity)this) && this.canPickUpLoot() && TreefolkAi.wantsToPickup(this, pStack);
    }

    protected void pickUpItem(ItemEntity pItemEntity) {
        this.onItemPickup(pItemEntity);
        TreefolkAi.pickUpItem(this, pItemEntity);
    }

    public void holdInOffHand(ItemStack stack) {
        if (TreefolkAi.isLovedItem(stack)) {
            this.setItemSlot(EquipmentSlot.OFFHAND, stack);
            this.setGuaranteedDrop(EquipmentSlot.OFFHAND);
        } else {
            this.setItemSlotAndDropWhenKilled(EquipmentSlot.OFFHAND, stack);
        }
    }

    public TreefolkArmPose getArmPose() {
        if (this.isDancing()) {
            return TreefolkArmPose.DANCING;
        }
        if (TreefolkAi.isLovedItem(this.getOffhandItem())) {
            return TreefolkArmPose.ADMIRING_ITEM;
        }
        return TreefolkArmPose.DEFAULT;
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(DATA_IS_DANCING);
    }

    public void setDancing(boolean pDancing) {
        this.entityData.set(DATA_IS_DANCING, (Object)pDancing);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        Entity entity;
        Level level = this.level();
        boolean flag = super.hurt(pSource, pAmount);
        if (level.isClientSide) {
            return false;
        }
        if (flag && (entity = pSource.getEntity()) instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entity;
            TreefolkAi.wasHurtBy(this, livingSource);
        }
        return flag;
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public LivingEntity getTarget() {
        return this.brain.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)EntityTypesPM.TREEFOLK.get().create((Level)pLevel);
    }
}

