/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.ai.behavior.LongDistanceRangedAttack;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.Fertilize;
import com.verdantartifice.primalmagick.common.entities.treefolk.JoinDanceParty;
import com.verdantartifice.primalmagick.common.entities.treefolk.StartAdmiringItemIfSeen;
import com.verdantartifice.primalmagick.common.entities.treefolk.StartDancingSometimes;
import com.verdantartifice.primalmagick.common.entities.treefolk.StartFertilizing;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopAdmiringIfItemTooFarAway;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopAdmiringIfTiredOfTryingToReachItem;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopFertilizingIfTiredOfTryingToReachBlock;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopHoldingItemIfNoLongerAdmiring;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import com.verdantartifice.primalmagick.common.loot.LootTablesPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreefolkAi {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final UniformInt ANGER_DURATION = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private static final UniformInt DANCE_COOLDOWN = TimeUtil.rangeOfSeconds((int)300, (int)900);
    private static final UniformInt FERTILIZE_COOLDOWN = TimeUtil.rangeOfSeconds((int)5, (int)10);
    private static final int RECENTLY_DANCED_DURATION = 1200;
    private static final int DANCE_DURATION = 600;
    private static final int ADMIRE_DURATION = 120;
    private static final int MAX_DISTANCE_TO_WALK_TO_ITEM = 9;
    private static final int MAX_TIME_TO_WALK_TO_ITEM = 200;
    private static final int HOW_LONG_TIME_TO_DISABLE_ADMIRE_WALKING_IF_CANT_REACH_ITEM = 200;
    private static final int HOW_LONG_TIME_TO_DISABLE_FERTILIZING_IF_CANT_REACH_BLOCK = 200;
    private static final int BABY_FLEE_DURATION_AFTER_GETTING_HIT = 100;
    private static final int HIT_BY_PLAYER_MEMORY_TIMEOUT = 400;
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final int RANGED_ATTACK_COOLDOWN = 30;
    private static final float MIN_RANGED_ATTACK_RANGE = 4.0f;
    private static final float MAX_RANGED_ATTACK_RANGE = 16.0f;
    private static final float MAX_FERTILIZE_RANGE = 2.0f;
    private static final int DESIRED_DISTANCE_FROM_ENTITY_WHEN_AVOIDING = 12;
    private static final int MAX_LOOK_DIST = 8;
    private static final int MAX_LOOK_DIST_FOR_PLAYER_HOLDING_LOVED_ITEM = 14;
    private static final int INTERACTION_RANGE = 8;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_WANTED_ITEM = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FIGHTING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FLEEING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_WORKING = 0.6f;
    private static final float SWIM_CHANCE = 0.8f;

    public static Brain<?> makeBrain(TreefolkEntity entity, Brain<TreefolkEntity> brain) {
        TreefolkAi.initCoreActivity(brain);
        TreefolkAi.initIdleActivity(brain);
        TreefolkAi.initAdmireItemActivity(brain);
        TreefolkAi.initFightActivity(entity, brain);
        TreefolkAi.initAvoidActivity(brain);
        TreefolkAi.initCelebrateActivity(brain);
        TreefolkAi.initWorkActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<TreefolkEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), StopHoldingItemIfNoLongerAdmiring.create(), StartAdmiringItemIfSeen.create(120), JoinDanceParty.create(600, 1200), (Object)StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<TreefolkEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)SetEntityLookTarget.create(TreefolkAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.create(TreefolkEntity::isAdult, TreefolkAi::findNearestValidAttackTarget), new StartFertilizing<TreefolkEntity>(TreefolkEntity::isAdult), StartDancingSometimes.create(600, 1200, DANCE_COOLDOWN), (Object)TryFindLand.create((int)8, (float)1.0f), TreefolkAi.createIdleLookBehaviors(), TreefolkAi.createIdleMovementBehaviors(), (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)));
    }

    private static void initAdmireItemActivity(Brain<TreefolkEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.ADMIRE_ITEM, 10, ImmutableList.of((Object)GoToWantedItem.create(TreefolkAi::isNotHoldingLovedItemInOffhand, (float)1.0f, (boolean)true, (int)9), new StopAdmiringIfItemTooFarAway(9), new StopAdmiringIfTiredOfTryingToReachItem(200, 200)), MemoryModuleType.ADMIRING_ITEM);
    }

    private static void initFightActivity(TreefolkEntity entity, Brain<TreefolkEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(living -> !TreefolkAi.isNearestValidAttackTarget(entity, living)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)MeleeAttack.create((int)20), new LongDistanceRangedAttack(30, 4.0f, 16.0f)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initAvoidActivity(Brain<TreefolkEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.0f, (int)12, (boolean)true), TreefolkAi.createIdleLookBehaviors(), TreefolkAi.createIdleMovementBehaviors()), MemoryModuleType.AVOID_TARGET);
    }

    private static void initCelebrateActivity(Brain<TreefolkEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.CELEBRATE, 10, ImmutableList.of((Object)SetEntityLookTarget.create(TreefolkAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.create(TreefolkEntity::isAdult, TreefolkAi::findNearestValidAttackTarget), (Object)BehaviorBuilder.triggerIf(t -> !t.isDancing(), (OneShot)GoToTargetLocation.create((MemoryModuleType)MemoryModuleType.CELEBRATE_LOCATION, (int)2, (float)1.0f)), (Object)BehaviorBuilder.triggerIf(TreefolkEntity::isDancing, (OneShot)GoToTargetLocation.create((MemoryModuleType)MemoryModuleType.CELEBRATE_LOCATION, (int)4, (float)0.6f)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create(EntityTypesPM.TREEFOLK.get(), (float)8.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.6f, (int)2, (int)1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), MemoryModuleType.CELEBRATE_LOCATION);
    }

    private static void initWorkActivity(Brain<TreefolkEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.WORK, 10, ImmutableList.of((Object)SetEntityLookTarget.create(TreefolkAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.create(TreefolkEntity::isAdult, TreefolkAi::findNearestValidAttackTarget), (Object)GoToTargetLocation.create(MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), (int)2, (float)0.6f), new StopFertilizingIfTiredOfTryingToReachBlock(200, 200), new Fertilize(2.0f, (IntProvider)FERTILIZE_COOLDOWN), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create(EntityTypesPM.TREEFOLK.get(), (float)8.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.6f, (int)2, (int)1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), MemoryModuleTypesPM.FERTILIZE_LOCATION.get());
    }

    private static RunOne<TreefolkEntity> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create(EntityTypesPM.TREEFOLK.get(), (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<TreefolkEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.of(EntityTypesPM.TREEFOLK.get(), (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(TreefolkAi::doesntSeeAnyPlayerHoldingLovedItem, (OneShot)SetWalkTargetFromLookTarget.create((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static boolean isPlayerHoldingLovedItem(LivingEntity entity) {
        return entity.getType() == EntityType.PLAYER && entity.isHolding(TreefolkAi::isLovedItem);
    }

    public static boolean isLovedItem(ItemStack stack) {
        return stack.is(ItemTagsPM.TREEFOLK_LOVED);
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(TreefolkEntity entity) {
        Optional attackablePlayerOptional;
        Brain<TreefolkEntity> brain = entity.getBrain();
        Optional<LivingEntity> angryAtOptional = TreefolkAi.getAngerTarget(entity);
        if (angryAtOptional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)entity, (LivingEntity)angryAtOptional.get())) {
            return angryAtOptional;
        }
        if (brain.hasMemoryValue(MemoryModuleType.UNIVERSAL_ANGER) && (attackablePlayerOptional = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)).isPresent()) {
            return attackablePlayerOptional;
        }
        return Optional.empty();
    }

    private static boolean isNearestValidAttackTarget(TreefolkEntity entity, LivingEntity target) {
        return TreefolkAi.findNearestValidAttackTarget(entity).filter(e -> e == target).isPresent();
    }

    private static boolean seesPlayerHoldingLovedItem(LivingEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM);
    }

    private static boolean doesntSeeAnyPlayerHoldingLovedItem(LivingEntity entity) {
        return !TreefolkAi.seesPlayerHoldingLovedItem(entity);
    }

    public static boolean wantsToPickup(TreefolkEntity entity, ItemStack stack) {
        if (TreefolkAi.isAdmiringDisabled(entity) && entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return false;
        }
        return TreefolkAi.isLovedItem(stack) && TreefolkAi.isNotHoldingLovedItemInOffhand(entity);
    }

    private static boolean isNotHoldingLovedItemInOffhand(TreefolkEntity entity) {
        return entity.getOffhandItem().isEmpty() || !TreefolkAi.isLovedItem(entity.getOffhandItem());
    }

    private static boolean isAdmiringDisabled(TreefolkEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_DISABLED);
    }

    public static void stopHoldingOffHandItem(TreefolkEntity entity, boolean shouldBarter) {
        ItemStack stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        entity.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        if (entity.isAdult()) {
            if (shouldBarter && TreefolkAi.isLovedItem(stack)) {
                TreefolkAi.throwItems(entity, TreefolkAi.getBarterResponseItems(entity));
            } else {
                TreefolkAi.throwItems(entity, Collections.singletonList(stack));
            }
        } else if (!TreefolkAi.isLovedItem(stack)) {
            TreefolkAi.throwItems(entity, Collections.singletonList(stack));
        }
    }

    private static void throwItems(TreefolkEntity entity, List<ItemStack> stacks) {
        entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).ifPresentOrElse(player -> TreefolkAi.throwItemsTowardPlayer(entity, player, stacks), () -> TreefolkAi.throwItemsTowardRandomPos(entity, stacks));
    }

    private static void throwItemsTowardPlayer(TreefolkEntity entity, Player player, List<ItemStack> stacks) {
        TreefolkAi.throwItemsTowardsPos(entity, stacks, player.position());
    }

    private static void throwItemsTowardRandomPos(TreefolkEntity entity, List<ItemStack> stacks) {
        TreefolkAi.throwItemsTowardsPos(entity, stacks, TreefolkAi.getRandomNearbyPos(entity));
    }

    private static void throwItemsTowardsPos(TreefolkEntity entity, List<ItemStack> stacks, Vec3 position) {
        if (!stacks.isEmpty()) {
            entity.swing(InteractionHand.OFF_HAND);
            for (ItemStack stack : stacks) {
                BehaviorUtils.throwItem((LivingEntity)entity, (ItemStack)stack, (Vec3)position.add(0.0, 1.0, 0.0));
            }
        }
    }

    private static Vec3 getRandomNearbyPos(TreefolkEntity entity) {
        Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)entity, (int)4, (int)2);
        return vec3 == null ? entity.position() : vec3;
    }

    private static List<ItemStack> getBarterResponseItems(TreefolkEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable table = serverLevel.getServer().reloadableRegistries().getLootTable(LootTablesPM.TREEFOLK_BARTERING);
            return table.getRandomItems(new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).create(LootContextParamSets.PIGLIN_BARTER));
        }
        return Collections.emptyList();
    }

    public static void pickUpItem(TreefolkEntity entity, ItemEntity itemEntity) {
        TreefolkAi.stopWalking(entity);
        entity.take((Entity)itemEntity, 1);
        ItemStack stack = TreefolkAi.removeOneItemFromItemEntity(itemEntity);
        if (TreefolkAi.isLovedItem(stack)) {
            entity.getBrain().eraseMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
            TreefolkAi.holdInOffhand(entity, stack);
            TreefolkAi.admireLovedItem(entity);
        } else {
            TreefolkAi.throwItemsTowardRandomPos(entity, Collections.singletonList(stack));
        }
    }

    private static void stopWalking(TreefolkEntity entity) {
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entity.getNavigation().stop();
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.getItem();
        ItemStack splitStack = stack.split(1);
        if (stack.isEmpty()) {
            itemEntity.discard();
        } else {
            itemEntity.setItem(stack);
        }
        return splitStack;
    }

    private static void holdInOffhand(TreefolkEntity entity, ItemStack stack) {
        if (TreefolkAi.isHoldingItemInOffHand(entity)) {
            entity.spawnAtLocation(entity.getItemInHand(InteractionHand.OFF_HAND));
        }
        entity.holdInOffHand(stack);
    }

    private static boolean isHoldingItemInOffHand(TreefolkEntity entity) {
        return !entity.getOffhandItem().isEmpty();
    }

    private static void admireLovedItem(TreefolkEntity entity) {
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, (Object)true, 120L);
    }

    public static void updateActivity(TreefolkEntity entity) {
        Brain<TreefolkEntity> brain = entity.getBrain();
        Activity activityBefore = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.ADMIRE_ITEM, (Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.CELEBRATE, (Object)Activity.WORK, (Object)Activity.IDLE));
        Activity activityAfter = brain.getActiveNonCoreActivity().orElse(null);
        if (activityBefore != activityAfter) {
            // empty if block
        }
        entity.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        if (!brain.hasMemoryValue(MemoryModuleType.CELEBRATE_LOCATION)) {
            brain.eraseMemory(MemoryModuleType.DANCING);
        }
        entity.setDancing(brain.hasMemoryValue(MemoryModuleType.DANCING));
    }

    public static void wasHurtBy(TreefolkEntity entity, LivingEntity target) {
        if (!(target instanceof TreefolkEntity)) {
            if (TreefolkAi.isHoldingItemInOffHand(entity)) {
                TreefolkAi.stopHoldingOffHandItem(entity, false);
            }
            Brain<TreefolkEntity> brain = entity.getBrain();
            brain.eraseMemory(MemoryModuleType.CELEBRATE_LOCATION);
            brain.eraseMemory(MemoryModuleType.DANCING);
            brain.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
            if (target instanceof Player) {
                brain.setMemoryWithExpiry(MemoryModuleType.ADMIRING_DISABLED, (Object)true, 400L);
            }
            TreefolkAi.getAvoidTarget(entity).ifPresent(avoid -> {
                if (avoid.getType() != target.getType()) {
                    brain.eraseMemory(MemoryModuleType.AVOID_TARGET);
                }
            });
            if (entity.isBaby()) {
                brain.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, 100L);
                if (Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)entity, (LivingEntity)target)) {
                    TreefolkAi.broadcastAngerTarget(entity, target);
                }
            } else {
                TreefolkAi.maybeRetaliate(entity, target);
            }
        }
    }

    private static Optional<LivingEntity> getAvoidTarget(TreefolkEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.AVOID_TARGET) ? entity.getBrain().getMemory(MemoryModuleType.AVOID_TARGET) : Optional.empty();
    }

    private static void maybeRetaliate(TreefolkEntity entity, LivingEntity target) {
        if (!entity.getBrain().isActive(Activity.AVOID) && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)entity, (LivingEntity)target) && !BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)entity, (LivingEntity)target, (double)4.0)) {
            if (target.getType() == EntityType.PLAYER && entity.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                TreefolkAi.setAngerTargetToNearestTargetablePlayerIfFound(entity, target);
                TreefolkAi.broadcastUniversalAnger(entity);
            } else {
                TreefolkAi.setAngerTarget(entity, target);
                TreefolkAi.broadcastAngerTarget(entity, target);
            }
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(TreefolkEntity entity, LivingEntity currentTarget) {
        TreefolkAi.getNearestVisibleTargetablePlayer(entity).ifPresentOrElse(player -> TreefolkAi.setAngerTarget(entity, (LivingEntity)player), () -> TreefolkAi.setAngerTarget(entity, currentTarget));
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(TreefolkEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) ? entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) : Optional.empty();
    }

    private static void setAngerTarget(TreefolkEntity entity, LivingEntity target) {
        Level level = entity.level();
        if (Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)entity, (LivingEntity)target)) {
            int angerDuration = ANGER_DURATION.sample(level.random);
            entity.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            entity.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)target.getUUID(), (long)angerDuration);
            if (target.getType() == EntityType.PLAYER && level.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                entity.getBrain().setMemoryWithExpiry(MemoryModuleType.UNIVERSAL_ANGER, (Object)true, (long)angerDuration);
            }
        }
    }

    private static void broadcastUniversalAnger(TreefolkEntity entity) {
        TreefolkAi.getNearbyAdultTreefolk(entity).forEach(t -> TreefolkAi.getNearestVisibleTargetablePlayer(t).ifPresent(p -> TreefolkAi.setAngerTarget(t, (LivingEntity)p)));
    }

    private static void broadcastAngerTarget(TreefolkEntity entity, LivingEntity target) {
        TreefolkAi.getNearbyAdultTreefolk(entity).forEach(t -> TreefolkAi.setAngerTargetIfCloserThanCurrent(t, target));
    }

    private static List<TreefolkEntity> getNearbyTreefolk(TreefolkEntity entity) {
        return (List)entity.getBrain().getMemory(MemoryModuleTypesPM.NEARBY_TREEFOLK.get()).orElse(ImmutableList.of());
    }

    private static List<TreefolkEntity> getNearbyAdultTreefolk(TreefolkEntity entity) {
        return (List)entity.getBrain().getMemory(MemoryModuleTypesPM.NEARBY_ADULT_TREEFOLK.get()).orElse(ImmutableList.of());
    }

    private static void setAngerTargetIfCloserThanCurrent(TreefolkEntity entity, LivingEntity currentTarget) {
        Optional<LivingEntity> livingOpt = TreefolkAi.getAngerTarget(entity);
        LivingEntity nearestTarget = BehaviorUtils.getNearestTarget((LivingEntity)entity, livingOpt, (LivingEntity)currentTarget);
        if (!livingOpt.isPresent() || livingOpt.get() != nearestTarget) {
            TreefolkAi.setAngerTarget(entity, nearestTarget);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(TreefolkEntity entity) {
        return BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
    }

    public static void startDanceParty(TreefolkEntity entity, int duration, int cooldown) {
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.DANCING, (Object)true, (long)duration);
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.CELEBRATE_LOCATION, (Object)entity.blockPosition(), (long)duration);
        entity.getBrain().setMemoryWithExpiry(MemoryModuleTypesPM.DANCED_RECENTLY.get(), (Object)true, (long)cooldown);
        TreefolkAi.broadcastCelebrateLocation(entity, duration);
    }

    public static void broadcastCelebrateLocation(TreefolkEntity entity, int danceDuration) {
        entity.getBrain().getMemory(MemoryModuleType.CELEBRATE_LOCATION).ifPresent(pos -> TreefolkAi.getNearbyTreefolk(entity).forEach(t -> t.getBrain().setMemoryWithExpiry(MemoryModuleType.CELEBRATE_LOCATION, pos, (long)danceDuration)));
    }

    public static InteractionResult mobInteract(TreefolkEntity entity, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (TreefolkAi.isLovedItem(stack)) {
            ItemStack splitStack = stack.split(1);
            TreefolkAi.holdInOffhand(entity, splitStack);
            TreefolkAi.admireLovedItem(entity);
            TreefolkAi.stopWalking(entity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean canAdmire(TreefolkEntity entity, ItemStack stack) {
        return !TreefolkAi.isAdmiringDisabled(entity) && !TreefolkAi.isAdmiringItem(entity) && entity.isAdult() && TreefolkAi.isLovedItem(stack);
    }

    private static boolean isAdmiringItem(TreefolkEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_ITEM);
    }
}

