/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class StopFertilizingIfTiredOfTryingToReachBlock<E extends TreefolkEntity>
extends Behavior<E> {
    private final int maxTimeToReachBlock;
    private final int disableTime;

    public StopFertilizingIfTiredOfTryingToReachBlock(int maxTimeToReachBlock, int disableTime) {
        super((Map)ImmutableMap.of(MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), (Object)MemoryStatus.VALUE_PRESENT, MemoryModuleTypesPM.TIME_TRYING_TO_REACH_FERTILIZE_BLOCK.get(), (Object)MemoryStatus.REGISTERED, MemoryModuleTypesPM.DISABLE_WALK_TO_FERTILIZE_BLOCK.get(), (Object)MemoryStatus.REGISTERED));
        this.maxTimeToReachBlock = maxTimeToReachBlock;
        this.disableTime = disableTime;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        Brain<TreefolkEntity> brain = ((TreefolkEntity)((Object)pEntity)).getBrain();
        brain.getMemory(MemoryModuleTypesPM.TIME_TRYING_TO_REACH_FERTILIZE_BLOCK.get()).ifPresentOrElse(time -> {
            if (time > this.maxTimeToReachBlock) {
                brain.eraseMemory(MemoryModuleTypesPM.FERTILIZE_LOCATION.get());
                brain.eraseMemory(MemoryModuleTypesPM.TIME_TRYING_TO_REACH_FERTILIZE_BLOCK.get());
                brain.setMemoryWithExpiry(MemoryModuleTypesPM.DISABLE_WALK_TO_FERTILIZE_BLOCK.get(), (Object)true, (long)this.disableTime);
            } else {
                brain.setMemory(MemoryModuleTypesPM.TIME_TRYING_TO_REACH_FERTILIZE_BLOCK.get(), (Object)(time + 1));
            }
        }, () -> brain.setMemory(MemoryModuleTypesPM.TIME_TRYING_TO_REACH_FERTILIZE_BLOCK.get(), (Object)0));
    }
}

