/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class StartFertilizing<E extends TreefolkEntity>
extends Behavior<E> {
    private final Predicate<E> canWorkPredicate;

    public StartFertilizing(Predicate<E> canWorkPredicate) {
        this(canWorkPredicate, 60);
    }

    public StartFertilizing(Predicate<E> canWorkPredicate, int duration) {
        super((Map)ImmutableMap.of(MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get(), (Object)MemoryStatus.VALUE_PRESENT, MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), (Object)MemoryStatus.VALUE_ABSENT, MemoryModuleTypesPM.FERTILIZED_RECENTLY.get(), (Object)MemoryStatus.VALUE_ABSENT, MemoryModuleTypesPM.DISABLE_WALK_TO_FERTILIZE_BLOCK.get(), (Object)MemoryStatus.VALUE_ABSENT), duration);
        this.canWorkPredicate = canWorkPredicate;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        ((TreefolkEntity)((Object)pEntity)).getBrain().getMemory(MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get()).ifPresent(list -> pEntity.getBrain().setMemory(MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), (Object)((BlockPos)list.get(0))));
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        return this.canWorkPredicate.test(pOwner) && !((TreefolkEntity)((Object)pOwner)).getBrain().getMemory(MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get()).orElse(Collections.emptyList()).isEmpty();
    }
}

