/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Fertilize<E extends TreefolkEntity>
extends Behavior<E> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final float maxDistanceSqr;
    private final IntProvider cooldownRange;

    public Fertilize(float maxDistance, IntProvider cooldownRange) {
        super((Map)ImmutableMap.of(MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), (Object)MemoryStatus.VALUE_PRESENT, MemoryModuleTypesPM.FERTILIZED_RECENTLY.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED));
        this.maxDistanceSqr = maxDistance * maxDistance;
        this.cooldownRange = cooldownRange;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        BonemealableBlock bonemealable;
        Brain<TreefolkEntity> brain = ((TreefolkEntity)((Object)pEntity)).getBrain();
        BlockPos targetPos = brain.getMemory(MemoryModuleTypesPM.FERTILIZE_LOCATION.get()).orElse(BlockPos.ZERO);
        brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(targetPos));
        BlockState state = pLevel.getBlockState(targetPos);
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)pLevel, targetPos, state)) {
            if (bonemealable.isBonemealSuccess((Level)pLevel, pLevel.random, targetPos, state)) {
                try {
                    bonemealable.performBonemeal(pLevel, pLevel.random, targetPos, state);
                }
                catch (Exception e) {
                    LOGGER.warn("Unexpected failure during treefolk plant fertilization", (Throwable)e);
                }
                pLevel.levelEvent(1505, targetPos, 0);
            }
            brain.setMemoryWithExpiry(MemoryModuleTypesPM.FERTILIZED_RECENTLY.get(), (Object)true, (long)this.cooldownRange.sample(pLevel.random));
            brain.eraseMemory(MemoryModuleTypesPM.FERTILIZE_LOCATION.get());
        }
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        Brain<TreefolkEntity> brain = ((TreefolkEntity)((Object)pOwner)).getBrain();
        Vec3 targetCenter = Vec3.atCenterOf((Vec3i)((Vec3i)brain.getMemory(MemoryModuleTypesPM.FERTILIZE_LOCATION.get()).orElse(BlockPos.ZERO)));
        return pOwner.position().distanceToSqr(targetCenter) <= (double)this.maxDistanceSqr;
    }
}

