/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellTrailPacket;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class SpellProjectileEntity
extends AbstractArrow {
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(SpellProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected final SpellPackage spell;
    protected final ItemStack spellSource;

    public SpellProjectileEntity(EntityType<? extends AbstractArrow> type, Level worldIn) {
        super(type, worldIn);
        this.spell = null;
        this.spellSource = null;
    }

    public SpellProjectileEntity(Level world, LivingEntity thrower, SpellPackage spell, @Nullable ItemStack spellSource) {
        super(EntityTypesPM.SPELL_PROJECTILE.get(), thrower, world, ItemStack.EMPTY, null);
        this.spell = spell;
        ItemStack itemStack = this.spellSource = spellSource == null ? null : spellSource.copy();
        if (spell != null && spell.payload() != null) {
            this.setColor(((AbstractSpellPayload)spell.payload().getComponent()).getSource().getColor());
        }
    }

    public SpellProjectileEntity(Level world, double x, double y, double z, SpellPackage spell, @Nullable ItemStack spellSource) {
        super(EntityTypesPM.SPELL_PROJECTILE.get(), x, y, z, world, ItemStack.EMPTY, null);
        this.spell = spell;
        ItemStack itemStack = this.spellSource = spellSource == null ? null : spellSource.copy();
        if (spell != null && spell.payload() != null) {
            this.setColor(((AbstractSpellPayload)spell.payload().getComponent()).getSource().getColor());
        }
    }

    @Nullable
    public SpellPackage getSpell() {
        return this.spell;
    }

    public int getColor() {
        return (Integer)this.getEntityData().get(COLOR);
    }

    protected void setColor(int color) {
        this.getEntityData().set(COLOR, (Object)color);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isAlive() && this.tickCount % 2 == 0 && this.spell != null && this.spell.payload() != null) {
                PacketHandler.sendToAllAround(new SpellTrailPacket(this.position(), ((AbstractSpellPayload)this.spell.payload().getComponent()).getSource().getColor()), serverLevel, this.blockPosition(), 64.0);
            }
        }
    }

    protected void onHit(HitResult result) {
        Level level = this.level();
        if (!level.isClientSide) {
            if (result.getType() == HitResult.Type.ENTITY && ((EntityHitResult)result).getEntity() instanceof SpellProjectileEntity) {
                return;
            }
            if (this.spell != null && this.spell.payload() != null) {
                LivingEntity shooter = this.getOwner() instanceof LivingEntity ? (LivingEntity)this.getOwner() : null;
                SpellManager.executeSpellPayload(this.spell, result, level, shooter, this.spellSource, true, (Entity)this);
            }
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(COLOR, (Object)0xFFFFFF);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public boolean canUsePortal(boolean pAllowPassengers) {
        return false;
    }
}

