/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpellMineEntity
extends Entity {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(SpellMineEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> ARMED = SynchedEntityData.defineId(SpellMineEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(SpellMineEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final int ARMING_TIME = 60;
    protected SpellPackage spell;
    protected UUID casterId;
    protected ItemStack spellSource;
    protected int currentLife = 0;

    public SpellMineEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.spell = null;
    }

    public SpellMineEntity(Level world, Vec3 pos, LivingEntity caster, SpellPackage spell, @Nullable ItemStack spellSource, int durationMinutes) {
        super(EntityTypesPM.SPELL_MINE.get(), world);
        this.setPos(pos.x, pos.y, pos.z);
        this.spell = spell;
        this.spellSource = spellSource.copy();
        this.casterId = caster.getUUID();
        this.setLifespan(1200 * durationMinutes);
        if (spell != null && spell.payload() != null) {
            this.setColor(((AbstractSpellPayload)spell.payload().getComponent()).getSource().getColor());
        }
    }

    @Nullable
    public SpellPackage getSpell() {
        return this.spell;
    }

    public int getColor() {
        return (Integer)this.getEntityData().get(COLOR);
    }

    protected void setColor(int color) {
        this.getEntityData().set(COLOR, (Object)color);
    }

    public boolean isArmed() {
        return (Boolean)this.getEntityData().get(ARMED);
    }

    protected void setArmed(boolean armed) {
        this.getEntityData().set(ARMED, (Object)armed);
    }

    protected int getLifespan() {
        return (Integer)this.getEntityData().get(LIFESPAN);
    }

    protected void setLifespan(int ticks) {
        this.getEntityData().set(LIFESPAN, (Object)ticks);
    }

    @Nullable
    public LivingEntity getCaster() {
        ServerLevel serverLevel;
        Level level;
        if (this.casterId != null && (level = this.level()) instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).getEntity(this.casterId)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)level;
            return living;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(COLOR, (Object)0xFFFFFF);
        pBuilder.define(ARMED, (Object)Boolean.FALSE);
        pBuilder.define(LIFESPAN, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Caster", 10)) {
            this.casterId = compound.getUUID("Caster");
        }
        this.spell = null;
        if (compound.contains("Spell", 10)) {
            this.spell = SpellPackage.deserializeNBT((Tag)compound.getCompound("Spell"), (HolderLookup.Provider)this.registryAccess());
        }
        if (this.spell != null && !this.spell.isValid()) {
            this.spell = null;
        }
        if (this.spell != null && this.spell.payload() != null) {
            this.setColor(((AbstractSpellPayload)this.spell.payload().getComponent()).getSource().getColor());
        }
        this.spellSource = null;
        if (compound.contains("SpellSource", 10)) {
            this.spellSource = ItemStack.OPTIONAL_CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.getCompound("SpellSource")).resultOrPartial(msg -> LOGGER.error("Failed to decode spell source: {}", msg)).orElse(ItemStack.EMPTY);
        }
        this.currentLife = compound.getInt("CurrentLife");
        this.setLifespan(compound.getInt("Lifespan"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.casterId != null) {
            compound.putUUID("Caster", this.casterId);
        }
        if (this.spell != null) {
            compound.put("Spell", this.spell.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        }
        if (this.spellSource != null) {
            ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.spellSource).resultOrPartial(msg -> LOGGER.error("Failed to encode spell source: {}", msg)).ifPresent(tag -> compound.put("SpellSource", tag));
        }
        compound.putInt("CurrentLife", this.currentLife);
        compound.putInt("Lifespan", this.getLifespan());
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (!(level.isClientSide || this.spell != null && this.spell.isValid())) {
            this.discard();
        }
        if (++this.currentLife > this.getLifespan()) {
            this.discard();
        }
        if (!level.isClientSide && this.isAlive()) {
            if (!this.isArmed() && this.currentLife >= 60) {
                this.setArmed(true);
            }
            if (this.isArmed() && this.currentLife % 5 == 0) {
                AABB aabb = new AABB(this.position(), this.position()).inflate(1.0);
                List entityList = level.getEntities((Entity)this, aabb, e -> e instanceof LivingEntity);
                boolean found = false;
                for (Entity entity : entityList) {
                    if (!entity.isAlive()) continue;
                    if (this.spell != null && this.spell.payload() != null) {
                        ((AbstractSpellPayload)this.spell.payload().getComponent()).playSounds(level, this.blockPosition());
                    }
                    if (this.getCaster() != null) {
                        SpellManager.executeSpellPayload(this.spell, (HitResult)new EntityHitResult(entity, this.position().add(0.0, 0.5, 0.0)), level, this.getCaster(), this.spellSource, false, this);
                    }
                    found = true;
                }
                if (found) {
                    this.discard();
                }
            }
        }
    }
}

