/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.entities.ManaArrowItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ManaArrowEntity
extends AbstractArrow {
    protected static final EntityDataAccessor<String> SOURCE_TAG = SynchedEntityData.defineId(ManaArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)Items.ARROW);

    public ManaArrowEntity(EntityType<? extends ManaArrowEntity> type, Level level) {
        super(type, level);
    }

    public ManaArrowEntity(Level level, LivingEntity shooter, Source source, ItemStack pickupItem, ItemStack weapon) {
        super(EntityTypesPM.MANA_ARROW.get(), shooter, level, pickupItem, weapon);
        this.setSource(source);
    }

    public ManaArrowEntity(Level pLevel, double pX, double pY, double pZ, Source source, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super(EntityTypesPM.MANA_ARROW.get(), pX, pY, pZ, pLevel, pPickupItemStack, pFiredFromWeapon);
        this.setSource(source);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SOURCE_TAG, (Object)"");
    }

    public void setSource(Source source) {
        this.entityData.set(SOURCE_TAG, (Object)source.getId().toString());
        if (source == Sources.SKY) {
            this.setNoGravity(true);
        } else if (source == Sources.INFERNAL) {
            this.igniteForSeconds(100.0f);
        } else if (source == Sources.HALLOWED) {
            this.setBaseDamage(this.getBaseDamage() + 1.0);
        }
    }

    @Nullable
    public Source getSource() {
        return Sources.get(ResourceLocation.parse((String)((String)this.entityData.get(SOURCE_TAG))));
    }

    protected ItemStack getPickupItem() {
        Item item = (Item)ManaArrowItem.SOURCE_MAPPING.get(this.getSource());
        return new ItemStack((ItemLike)(item == null ? Items.ARROW : item));
    }

    public void tick() {
        super.tick();
        if (this.getSource() == Sources.SKY && this.isNoGravity() && this.isInWater()) {
            this.setNoGravity(false);
        }
        Level level = this.level();
        if (level.isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        }
    }

    protected void makeParticle(int count) {
        Source source = this.getSource();
        if (source != null && count > 0) {
            Level level = this.level();
            RandomSource rng = level.random;
            int color = source.getColor();
            for (int index = 0; index < count; ++index) {
                double dx = (double)rng.nextFloat() * 0.035 * (double)(rng.nextBoolean() ? 1 : -1);
                double dy = (double)rng.nextFloat() * 0.035 * (double)(rng.nextBoolean() ? 1 : -1);
                double dz = (double)rng.nextFloat() * 0.035 * (double)(rng.nextBoolean() ? 1 : -1);
                FxDispatcher.INSTANCE.manaArrowTrail(this.getX(), this.getY(), this.getZ(), dx, dy, dz, color);
            }
        }
    }

    protected void doPostHurtEffects(LivingEntity target) {
        super.doPostHurtEffects(target);
        Source source = this.getSource();
        if (source == Sources.SEA) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 50));
        } else if (source == Sources.SUN) {
            target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 50));
            if (target.isInvertedHealAndHarm()) {
                target.igniteForSeconds(3.0f);
            }
        } else if (source == Sources.MOON) {
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 50));
        } else if (source == Sources.BLOOD) {
            target.addEffect(new MobEffectInstance(EffectsPM.BLEEDING.getHolder(), 50));
        } else if (source == Sources.VOID) {
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 50));
        } else if (source == Sources.HALLOWED && target.isInvertedHealAndHarm()) {
            target.igniteForSeconds(3.0f);
        }
    }

    protected float getWaterInertia() {
        Source source = this.getSource();
        return source == Sources.SEA || source == Sources.BLOOD ? 0.99f : super.getWaterInertia();
    }

    protected ItemStack getDefaultPickupItem() {
        return DEFAULT_ARROW_STACK;
    }

    protected void doKnockback(LivingEntity pEntity, DamageSource pDamageSource) {
        float f;
        Level level;
        float baseForce;
        float f2 = baseForce = this.getSource() == Sources.EARTH ? 2.0f : 0.0f;
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)pEntity, (DamageSource)pDamageSource, (float)baseForce);
        } else {
            f = baseForce;
        }
        double force = f;
        if (force > 0.0) {
            double inertia = Math.max(0.0, 1.0 - pEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 pushVec = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(force * 0.6 * inertia);
            if (pushVec.lengthSqr() > 0.0) {
                pEntity.push(pushVec.x, 0.1, pushVec.z);
            }
        }
    }
}

