/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class AppleEntity
extends ThrowableItemProjectile {
    public AppleEntity(EntityType<? extends AppleEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public AppleEntity(Level world, LivingEntity thrower) {
        super(EntityTypesPM.APPLE.get(), thrower, world);
    }

    public AppleEntity(Level world, double x, double y, double z) {
        super(EntityTypesPM.APPLE.get(), x, y, z, world);
    }

    protected Item getDefaultItem() {
        return Items.APPLE;
    }

    private ParticleOptions makeParticle() {
        return new ItemParticleOption(ParticleTypes.ITEM, this.getItem());
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleData = this.makeParticle();
            for (int index = 0; index < 8; ++index) {
                this.level().addParticle(particleData, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), 2.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (!level.isClientSide) {
            level.broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }
}

