/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PotionExplosionPacket;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class AlchemicalBombEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::isSensitiveToWater;

    public AlchemicalBombEntity(EntityType<? extends AlchemicalBombEntity> entityType, Level world) {
        super(entityType, world);
    }

    public AlchemicalBombEntity(Level world, LivingEntity entity) {
        super(EntityTypesPM.ALCHEMICAL_BOMB.get(), entity, world);
    }

    public AlchemicalBombEntity(Level world, double x, double y, double z) {
        super(EntityTypesPM.ALCHEMICAL_BOMB.get(), x, y, z, world);
    }

    protected Item getDefaultItem() {
        return ItemsPM.ALCHEMICAL_BOMB.get();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    public void tick() {
        super.tick();
        FuseType fuse = ConcoctionUtils.getFuseType(this.getItem());
        if (fuse != null && fuse.hasTimer() && this.tickCount >= fuse.getFuseLength()) {
            this.detonate(null);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        FuseType fuse = ConcoctionUtils.getFuseType(this.getItem());
        if (fuse == FuseType.IMPACT) {
            this.detonate(null);
        } else if (fuse != null) {
            double mx = result.getDirection().getStepX() == 0 ? 1.0 : -1.0;
            double my = 0.9 * (result.getDirection().getStepY() == 0 ? 1.0 : -1.0);
            double mz = result.getDirection().getStepZ() == 0 ? 1.0 : -1.0;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7).multiply(mx, my, mz));
            Level level = this.level();
            if (!level.isClientSide) {
                float volume = Mth.clamp((float)((float)this.getDeltaMovement().length()), (float)0.0f, (float)1.0f);
                this.playSound(SoundsPM.CLANK.get(), volume, 0.8f + 0.4f * level.random.nextFloat());
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        this.detonate(result.getEntity());
    }

    private void detonate(@Nullable Entity struckEntity) {
        Level level = this.level();
        ItemStack itemStack = this.getItem();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (itemStack.has(DataComponents.POTION_CONTENTS)) {
                PotionContents contents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
                Optional potionHolderOpt = contents.potion();
                potionHolderOpt.ifPresent(potionHolder -> {
                    List effects = ((Potion)potionHolder.value()).getEffects();
                    PacketHandler.sendToAllAround(new PotionExplosionPacket(this.position(), PotionContents.getColor((Holder)potionHolder), ((Potion)potionHolder.value()).hasInstantEffects()), serverLevel, this.blockPosition(), 32.0);
                    if (contents.is(Potions.WATER) && effects.isEmpty()) {
                        this.applyWater();
                    } else if (!effects.isEmpty()) {
                        this.applyPotionEffects(effects, struckEntity);
                    }
                });
                this.discard();
            }
        }
    }

    private void applyWater() {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, aabb, WATER_SENSITIVE);
        for (LivingEntity entity : entities) {
            double distanceSq = this.distanceToSqr((Entity)entity);
            if (!(distanceSq < 16.0) || !entity.isSensitiveToWater()) continue;
            entity.hurt(this.level().damageSources().indirectMagic((Entity)entity, this.getOwner()), 1.0f);
        }
        BlockPos pos = this.blockPosition();
        this.extinguishFire(pos);
        for (Direction dir : Direction.values()) {
            this.extinguishFire(pos.relative(dir));
        }
    }

    private void applyPotionEffects(List<MobEffectInstance> effects, @Nullable Entity struckEntity) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List entityList = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        for (LivingEntity entity : entityList) {
            double distanceSq;
            if (!entity.isAffectedByPotions() || !((distanceSq = this.distanceToSqr((Entity)entity)) < 16.0)) continue;
            double multiplier = entity == struckEntity ? 1.0 : 1.0 - Math.sqrt(distanceSq) / 4.0;
            for (MobEffectInstance effectInstance : effects) {
                Holder effect = effectInstance.getEffect();
                if (((MobEffect)effect.value()).isInstantenous()) {
                    ((MobEffect)effect.value()).applyInstantenousEffect((Entity)this, this.getOwner(), entity, effectInstance.getAmplifier(), multiplier);
                    continue;
                }
                int scaledDuration = (int)(multiplier * (double)effectInstance.getDuration() + 0.5);
                if (scaledDuration <= 20) continue;
                entity.addEffect(new MobEffectInstance(effect, scaledDuration, effectInstance.getAmplifier(), effectInstance.isAmbient(), effectInstance.isVisible()));
            }
        }
    }

    private void extinguishFire(BlockPos pos) {
        Level level = this.level();
        BlockState state = level.getBlockState(pos);
        if (state.is(BlockTags.FIRE)) {
            level.removeBlock(pos, false);
        } else if (CampfireBlock.isLitCampfire((BlockState)state)) {
            level.levelEvent(null, 1009, pos, 0);
            CampfireBlock.dowse((Entity)this.getOwner(), (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }
}

