/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractTridentEntity
extends AbstractArrow {
    protected static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.defineId(AbstractTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Boolean> HAS_GLINT = SynchedEntityData.defineId(AbstractTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected ItemStack thrownStack;
    protected boolean dealtDamage;
    public int returningTicks;

    public AbstractTridentEntity(EntityType<? extends AbstractTridentEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public AbstractTridentEntity(EntityType<? extends AbstractTridentEntity> type, Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(type, thrower, worldIn, thrownStackIn, null);
        this.thrownStack = thrownStackIn.copy();
        this.entityData.set(LOYALTY_LEVEL, (Object)this.getLoyaltyFromItem(this.thrownStack));
        this.entityData.set(HAS_GLINT, (Object)this.thrownStack.hasFoil());
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(LOYALTY_LEVEL, (Object)0);
        pBuilder.define(HAS_GLINT, (Object)false);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity shooter = this.getOwner();
        Level level = this.level();
        if ((this.dealtDamage || this.isNoPhysics()) && shooter != null) {
            byte loyalty = (Byte)this.entityData.get(LOYALTY_LEVEL);
            if (loyalty > 0 && !this.shouldReturnToThrower()) {
                if (!level.isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else if (loyalty > 0) {
                this.setNoPhysics(true);
                Vec3 vector3d = new Vec3(shooter.getX() - this.getX(), shooter.getEyeY() - this.getY(), shooter.getZ() - this.getZ());
                this.setPosRaw(this.getX(), this.getY() + vector3d.y * 0.015 * (double)loyalty, this.getZ());
                if (level.isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)loyalty;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vector3d.normalize().scale(d0)));
                if (this.returningTicks == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.tick();
    }

    private boolean shouldReturnToThrower() {
        Entity shooter = this.getOwner();
        if (shooter != null && shooter.isAlive()) {
            return !(shooter instanceof ServerPlayer) || !shooter.isSpectator();
        }
        return false;
    }

    protected ItemStack getPickupItem() {
        return this.thrownStack.copy();
    }

    public boolean hasGlint() {
        return (Boolean)this.entityData.get(HAS_GLINT);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    public abstract double getBaseDamage();

    protected void onHitEntity(EntityHitResult pResult) {
        ServerLevel serverLevel;
        Entity victim = pResult.getEntity();
        float damage = (float)this.getBaseDamage();
        Entity attacker = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(attacker == null ? this : attacker));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)victim, (DamageSource)damageSource, (float)damage);
        }
        this.dealtDamage = true;
        if (victim.hurt(damageSource, damage)) {
            if (victim.getType() == EntityType.ENDERMAN) {
                return;
            }
            level = this.level();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)victim, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
            }
            if (victim instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)victim;
                this.doKnockback(livingEntity, damageSource);
                this.doPostHurtEffects(livingEntity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    protected void hitBlockEnchantmentEffects(ServerLevel pLevel, BlockHitResult pHitResult, ItemStack pStack) {
        LivingEntity livingentity;
        Vec3 vec3 = pHitResult.getBlockPos().clampLocationWithin(pHitResult.getLocation());
        Entity entity = this.getOwner();
        EnchantmentHelper.onHitBlock((ServerLevel)pLevel, (ItemStack)pStack, (LivingEntity)(entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null), (Entity)this, null, (Vec3)vec3, (BlockState)pLevel.getBlockState(pHitResult.getBlockPos()), item -> this.kill());
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player entityIn) {
        Entity shooter = this.getOwner();
        if (shooter == null || shooter.getUUID() == entityIn.getUUID()) {
            super.playerTouch(entityIn);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.dealtDamage = compound.getBoolean("DealtDamage");
        this.entityData.set(LOYALTY_LEVEL, (Object)this.getLoyaltyFromItem(this.thrownStack));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DealtDamage", this.dealtDamage);
    }

    protected void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || (Byte)this.entityData.get(LOYALTY_LEVEL) <= 0) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    protected byte getLoyaltyFromItem(ItemStack pStack) {
        byte by;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)pStack, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }
}

