/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.pixies.guardians;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.entities.misc.PixieHouseEntity;
import com.verdantartifice.primalmagick.common.entities.pixies.IPixie;
import com.verdantartifice.primalmagick.common.items.misc.DrainedPixieItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadsPM;
import com.verdantartifice.primalmagick.common.spells.vehicles.BoltSpellVehicle;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuardianPixieEntity
extends PathfinderMob
implements NeutralMob,
FlyingAnimal,
RangedAttackMob,
IPixie {
    protected static final EntityDataAccessor<Integer> DATA_ANGER_TIME = SynchedEntityData.defineId(AbstractGuardianPixieEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_HOME = SynchedEntityData.defineId(AbstractGuardianPixieEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<String> DATA_SOURCE_TAG = SynchedEntityData.defineId(AbstractGuardianPixieEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    protected static final byte PIXIE_DUST_EVENT = 15;
    @Nullable
    protected Source source;
    @Nullable
    protected SpellPackage spellCache;
    protected int attackTimer;
    @Nullable
    protected UUID angerTarget;
    @Nullable
    protected PixieHouseEntity homeCache;

    protected AbstractGuardianPixieEntity(EntityType<? extends AbstractGuardianPixieEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, false);
    }

    public static <T extends AbstractGuardianPixieEntity> T spawn(EntityType<T> entityType, Source source, PixieHouseEntity home, ServerLevel level, BlockPos pos) {
        AbstractGuardianPixieEntity pixie = (AbstractGuardianPixieEntity)entityType.create(level, $ -> {}, pos, MobSpawnType.SPAWN_EGG, true, true);
        if (pixie != null) {
            pixie.setPixieSource(source);
            pixie.setHome(home);
            level.addFreshEntityWithPassengers((Entity)pixie);
        }
        return (T)pixie;
    }

    @Override
    public Source getPixieSource() {
        if (this.source == null) {
            this.source = Sources.get(ResourceLocation.parse((String)((String)this.entityData.get(DATA_SOURCE_TAG))));
        }
        return this.source;
    }

    protected void setPixieSource(Source source) {
        this.source = source;
        this.entityData.set(DATA_SOURCE_TAG, (Object)source.getId().toString());
    }

    @Nullable
    public PixieHouseEntity getHome() {
        Level level;
        if (this.homeCache == null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.homeCache = ((Optional)this.entityData.get(DATA_HOME)).map(u -> {
                PixieHouseEntity house;
                Entity patt0$temp = serverLevel.getEntity(u);
                return patt0$temp instanceof PixieHouseEntity ? (house = (PixieHouseEntity)patt0$temp) : null;
            }).orElse(null);
        }
        return this.homeCache;
    }

    public void setHome(@NotNull PixieHouseEntity home) {
        this.homeCache = home;
        this.entityData.set(DATA_HOME, Optional.of(home.getUUID()));
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @Nonnull
    protected SpellPackage createSpellPackage() {
        return SpellPackage.builder().name("Pixie Bolt").vehicle().type(BoltSpellVehicle.INSTANCE).with(SpellPropertiesPM.RANGE.get(), 2).end().payload().type(this.getSpellPayload()).with(SpellPropertiesPM.POWER.get(), this.getSpellPower()).with(SpellPropertiesPM.DURATION.get(), this.getSpellPower()).end().build();
    }

    @Nonnull
    protected AbstractSpellPayload<?> getSpellPayload() {
        return SpellPayloadsPM.getSpellDamagePayload(this.getPixieSource());
    }

    @Nonnull
    protected SpellPackage getSpellPackage() {
        if (this.spellCache == null) {
            this.spellCache = this.createSpellPackage();
        }
        return this.spellCache;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new StayNearHomeGoal(this, 0.9, 16.0f, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 30, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(4, (Goal)new EnterHomeGoal(this, 0.5f));
        this.goalSelector.addGoal(5, (Goal)new ReturnHomeGoal(this, 0.9, 0.5f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HomeAngerTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ANGER_TIME, (Object)0);
        pBuilder.define(DATA_HOME, Optional.empty());
        pBuilder.define(DATA_SOURCE_TAG, (Object)Sources.EARTH.getId().toString());
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.addPersistentAngerSaveData(pCompound);
        if (this.getHome() != null) {
            pCompound.putUUID("HomeEntity", this.getHome().getUUID());
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            this.readPersistentAngerSaveData((Level)serverLevel, pCompound);
            if (pCompound.hasUUID("HomeEntity") && (entity = serverLevel.getEntity(pCompound.getUUID("HomeEntity"))) instanceof PixieHouseEntity) {
                PixieHouseEntity house = (PixieHouseEntity)entity;
                this.setHome(house);
            }
        }
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(DATA_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        Level level = this.level();
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.updatePersistentAnger(serverLevel, true);
            if (this.isAlive()) {
                level.broadcastEntityEvent((Entity)this, (byte)15);
            }
        }
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
    }

    public void handleEntityEvent(byte id) {
        if (id == 15 && this.getPixieSource() != null) {
            FxDispatcher.INSTANCE.pixieDust(this.getX() + this.random.nextGaussian() * 0.25, this.getY() + 0.25, this.getZ() + this.random.nextGaussian() * 0.25, this.getPixieSource().getColor());
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.BAT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    public void die(DamageSource pDamageSource) {
        if (!this.isRemoved() && !this.dead && this.getHome() != null) {
            this.getHome().setHousedPixie(DrainedPixieItem.getDrainedPixie(this.getPixieRank(), this.getPixieSource()));
            this.getHome().removeDeployedPixie();
        }
        super.die(pDamageSource);
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public boolean canBeLeashed() {
        return false;
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, worldIn);
        nav.setCanOpenDoors(false);
        nav.setCanPassDoors(true);
        return nav;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.getSpellPackage().cast(this.level(), (LivingEntity)this, ItemStack.EMPTY);
    }

    protected static class StayNearHomeGoal
    extends Goal {
        private final AbstractGuardianPixieEntity mob;
        @Nullable
        private LivingEntity home;
        @Nullable
        private Vec3 wantedPos;
        private final double speedModifier;
        private final double startDistanceSqr;
        private final double stopDistanceSqr;

        public StayNearHomeGoal(AbstractGuardianPixieEntity mob, double speedModifier, float startDistance, float stopDistance) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.startDistanceSqr = startDistance * startDistance;
            this.stopDistanceSqr = stopDistance * stopDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.home = this.mob.getHome();
            if (this.home == null) {
                return false;
            }
            if (this.home.distanceToSqr((Entity)this.mob) < this.startDistanceSqr) {
                return false;
            }
            this.wantedPos = this.home.position().add(0.0, 1.5, 0.0);
            return true;
        }

        public boolean canContinueToUse() {
            return !this.mob.getNavigation().isDone() && this.home != null && this.home.isAlive() && this.home.distanceToSqr((Entity)this.mob) > this.stopDistanceSqr;
        }

        public void stop() {
            this.home = null;
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.wantedPos.x(), this.wantedPos.y(), this.wantedPos.z(), this.speedModifier);
        }
    }

    protected static class EnterHomeGoal
    extends Goal {
        private final AbstractGuardianPixieEntity mob;
        @Nullable
        private PixieHouseEntity home;
        private final double withinDistanceSqr;

        public EnterHomeGoal(AbstractGuardianPixieEntity mob, float withinDistance) {
            this.mob = mob;
            this.withinDistanceSqr = withinDistance * withinDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.home = this.mob.getHome();
            if (this.home == null) {
                return false;
            }
            if (this.mob.getPersistentAngerTarget() != null) {
                return false;
            }
            return this.home.distanceToSqr((Entity)this.mob) < this.withinDistanceSqr;
        }

        public void start() {
            if (this.home != null) {
                this.home.undeployGuardian();
            }
        }
    }

    protected static class ReturnHomeGoal
    extends Goal {
        private final AbstractGuardianPixieEntity mob;
        @Nullable
        private LivingEntity home;
        @Nullable
        private Vec3 wantedPos;
        private final double speedModifier;
        private final double targetDistanceSqr;

        public ReturnHomeGoal(AbstractGuardianPixieEntity mob, double speedModifier, float targetDistance) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.targetDistanceSqr = targetDistance * targetDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.home = this.mob.getHome();
            if (this.home == null) {
                return false;
            }
            if (this.mob.getPersistentAngerTarget() != null) {
                return false;
            }
            if (this.home.distanceToSqr((Entity)this.mob) < this.targetDistanceSqr) {
                return false;
            }
            this.wantedPos = this.home.position().add(0.0, 1.5, 0.0);
            return true;
        }

        public boolean canContinueToUse() {
            return !this.mob.getNavigation().isDone() && this.home != null && this.home.isAlive() && this.home.distanceToSqr((Entity)this.mob) > this.targetDistanceSqr;
        }

        public void stop() {
            this.home = null;
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.wantedPos.x(), this.wantedPos.y(), this.wantedPos.z(), this.speedModifier);
        }
    }

    protected static class HomeAngerTargetGoal
    extends TargetGoal {
        private final AbstractGuardianPixieEntity mob;
        private LivingEntity attacked;
        private int timestamp;

        public HomeAngerTargetGoal(AbstractGuardianPixieEntity mob) {
            super((Mob)mob, false);
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            PixieHouseEntity home = this.mob.getHome();
            if (home != null && home.getTarget() != null) {
                this.attacked = home.getTarget();
                int time = home.getTargetTimestamp();
                return time != this.timestamp && this.canAttack(this.attacked, TargetingConditions.DEFAULT);
            }
            return false;
        }

        public void start() {
            this.mob.setPersistentAngerTarget(this.attacked.getUUID());
            this.mob.setTarget(this.attacked);
            PixieHouseEntity home = this.mob.getHome();
            if (home != null) {
                this.timestamp = home.getTargetTimestamp();
            }
            super.start();
        }
    }
}

