/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.pixies.companions;

import com.verdantartifice.primalmagick.common.entities.pixies.companions.AbstractPixieEntity;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.HealingSpellPayload;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractSunPixieEntity
extends AbstractPixieEntity {
    public AbstractSunPixieEntity(EntityType<? extends AbstractPixieEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public Source getPixieSource() {
        return Sources.SUN;
    }

    @Override
    protected AbstractSpellPayload<?> getSpellPayload() {
        return HealingSpellPayload.INSTANCE;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new HealOwnerGoal(this, 1.0, 20, 30, 16.0f));
    }

    public void castSpell() {
        this.getSpellPackage().cast(this.level(), (LivingEntity)this, ItemStack.EMPTY);
    }

    protected static class HealOwnerGoal
    extends Goal {
        protected final AbstractSunPixieEntity pixie;
        protected final double moveSpeed;
        protected final int castIntervalMin;
        protected final int castIntervalMax;
        protected final float castRadius;
        protected final float maxCastDistanceSq;
        protected LivingEntity castTarget;
        protected int seeTime;
        protected int castTime = -1;

        public HealOwnerGoal(AbstractSunPixieEntity pixie, double moveSpeed, int minCastTime, int maxCastTime, float maxCastDistance) {
            this.pixie = pixie;
            this.moveSpeed = moveSpeed;
            this.castIntervalMin = minCastTime;
            this.castIntervalMax = maxCastTime;
            this.castRadius = maxCastDistance;
            this.maxCastDistanceSq = maxCastDistance * maxCastDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            Player target = this.pixie.getCompanionOwner();
            if (target != null && target.isAlive() && target.getHealth() / target.getMaxHealth() < 0.75f) {
                this.castTarget = target;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUse() || !this.pixie.getNavigation().isDone();
        }

        public void stop() {
            this.castTarget = null;
            this.seeTime = 0;
            this.castTime = -1;
        }

        public void tick() {
            float distSq = (float)this.pixie.distanceToSqr((Entity)this.castTarget);
            boolean canSee = this.pixie.getSensing().hasLineOfSight((Entity)this.castTarget);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if (distSq <= this.maxCastDistanceSq && this.seeTime >= 5) {
                this.pixie.getNavigation().stop();
            } else {
                this.pixie.getNavigation().moveTo((Entity)this.castTarget, this.moveSpeed);
            }
            this.pixie.getLookControl().setLookAt((Entity)this.castTarget, 30.0f, 30.0f);
            if (--this.castTime == 0) {
                if (!canSee) {
                    return;
                }
                float f = Mth.sqrt((float)distSq) / this.castRadius;
                this.pixie.castSpell();
                this.castTime = Mth.floor((float)(f * (float)(this.castIntervalMax - this.castIntervalMin) + (float)this.castIntervalMin));
            } else if (this.castTime < 0) {
                float f = Mth.sqrt((float)distSq) / this.castRadius;
                this.castTime = Mth.floor((float)(f * (float)(this.castIntervalMax - this.castIntervalMin) + (float)this.castIntervalMin));
            }
        }
    }
}

